"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * 表单组件
 * @param {[type]} dataModel [description]
 */
var Form = /*#__PURE__*/function (_ContainerComponent) {
  _inherits(Form, _ContainerComponent);

  var _super = _createSuper(Form);

  function Form(__tfp, dataModel, parent) {
    _classCallCheck(this, Form);

    return _super.call(this, __tfp, "Form", dataModel, parent);
  } //loadDataService属性


  _createClass(Form, [{
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    } //dataBindingMember属性

  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    } //submitService属性

  }, {
    key: "submitService",
    get: function get() {
      return this.dataModel.submitService;
    },
    set: function set(value) {
      this.dataModel.submitService = value;
    } //是否显示提交成功提示

  }, {
    key: "showSubmitSuccessHint",
    get: function get() {
      return this.dataModel.showSubmitSuccessHint ? true : false;
    },
    set: function set(value) {
      this.dataModel.showSubmitSuccessHint = value ? true : false;
    }
    /**
     * 校验表单输入项的数据是否符合要求
     * @param  {[type]} ipt  [description]
     * @param  {[type]} args [description]
     * @return {[type]}      [description]
     */

  }, {
    key: "checkInputData",
    value: function checkInputData(cdm, args) {
      var cpt = this._tfp.get(cdm.id);

      var cptTypeInfo = this._tfp.type(cpt.type);

      if (cpt.isFormInput) {
        if (cpt.required && isNull(cpt.value)) {
          if (cpt.placeHolder) {
            this._tfp.showMsg(cpt.placeHolder);
          } else if (cpt.comment) {
            this._tfp.showMsg(cpt.comment + "不能为空！");
          } else {
            this._tfp.showMsg(cpt.id + "不能为空！");
          }

          if (cpt.focus) cpt.focus();
          return false;
        }

        if (!isNull(cpt.value)) {
          args[cpt.id] = cpt.value;
          /*if(ipt.type=="DateTime" && ipt.value.length<19) {
            args[ipt.id] = ipt.value + ":00";
          } else if(ipt.type=="Date" && ipt.value.length<19) {
            args[ipt.id] = ipt.value + " 0:00:00";
          }*/
        }
      } else if (cpt.type == "DataSet") {
        var rows = cpt.getRows({
          checkRequired: true
        });
        if (!rows) return false;
        args[cpt.id] = rows;
      }

      var isOK = true;

      if (cdm.components) {
        for (var i = 0; i < cdm.components.length; i++) {
          isOK = this.checkInputData(cdm.components[i], args);
          if (!isOK) return false;
        }
      }

      return isOK;
    }
  }, {
    key: "submit",
    value: function submit() {
      if (!this.dataModel.submitService) {
        alert("请为[" + this.id + "]设置数据提交服务！");
        return;
      }

      var serviceCpt = this._tfp.get(this.dataModel.submitService);

      if (!serviceCpt) {
        alert("ID为[" + this.dataModel.submitService + "]的组件不存在！");
        return;
      } //对表单内的输入项的数据进行校验，并生成请求参数


      var args = {};
      var isOK = true;

      if (this.dataModel.components) {
        for (var i = 0; i < this.dataModel.components.length; i++) {
          isOK = this.checkInputData(this.dataModel.components[i], args);
          if (!isOK) return;
        }
      }

      var that = this;
      serviceCpt.request(args, function (req, res) {
        if (that.dataModel.showSubmitSuccessHint) that._tfp.showMsg("提交成功！");
        /*if(that._tfp.curPage.pagetype=="dialog") {
          onDialogOK({req: req, res: res});
          closeCurDialog();
        }*/
      });
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (!this.dataModel.components) return;

      for (var i = 0; i < this.dataModel.components.length; i++) {
        this._tfp.bindCptData(this.dataModel.components[i], data);
      }
    }
  }, {
    key: "loadData",
    value: function loadData() {
      if (!this.dataModel.loadDataService) {
        alert("请为[" + this.id + "]设置加载数据服务！");
        return;
      }

      var serviceCpt = this._tfp.get(this.dataModel.loadDataService);

      if (!serviceCpt) {
        alert("ID为[" + this.dataModel.loadDataService + "]的组件不存在！");
        return;
      }

      var that = this; //与服务组件建立绑定

      if (!serviceCpt.bindCpts) serviceCpt.bindCpts = [];
      if (!serviceCpt.bindCpts.contains(this.id)) serviceCpt.bindCpts.push(this.id);
      serviceCpt.request(null, function (req, res) {
        var data = res; //如果设置了数据绑定成员名称，则从服务响应对象中取这个成员对象作为表单的数据源
        //否则，将整个响应对象作为表单的数据源

        if (that.dataModel.dataBindingMember) data = res[that.dataModel.dataBindingMember]; //把表单的数据先缓存起来，以便后续某些场景需要继续使用

        that.dataModel.data = data;
        that.bindData(data);
      });
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      if (!this.dataModel.loadDataService) return;
      this.loadData();
    }
  }]);

  return Form;
}(_controller.ContainerComponent);

exports["default"] = Form;