"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * 数据表格组件
 * @param {[type]} dataModel [description]
 */
var Grid = /*#__PURE__*/function (_VisibleComponent) {
  _inherits(Grid, _VisibleComponent);

  var _super = _createSuper(Grid);

  function Grid(__tfp, dataModel, parent) {
    var _this;

    _classCallCheck(this, Grid);

    _this = _super.call(this, __tfp, "Grid", dataModel, parent);
    _this.pageSize = 20;
    _this.curPage = 0;
    _this.pageCount = 0;
    _this.rowsCount = 0;
    _this.dataList = [];

    if (__tfp.isDesigning) {
      if (!_this.dataModel.components || _this.dataModel.components.length == 0) {
        _this.dataModel.components = [{
          id: _this.id + "_DataRow",
          type: "GridDataRow",
          styles: {
            "position": "absolute",
            "top": "0",
            "left": "10px",
            "right": "10px",
            "height": "60px",
            "border": "1px solid #cccccc",
            "border-radius": "10px"
          }
        }];
      }
    }

    return _this;
  } //属性


  _createClass(Grid, [{
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    }
  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    }
  }, {
    key: "dataBindingKey",
    get: function get() {
      return this.dataModel.dataBindingKey;
    },
    set: function set(value) {
      this.dataModel.dataBindingKey = value;
    }
  }, {
    key: "showSearchBox",
    get: function get() {
      return this.dataModel.showSearchBox;
    },
    set: function set(value) {
      this.dataModel.showSearchBox = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.showSearchBox) {
          if (this._jqObj.find(".tfp-grid-searchbox").length > 0) {
            this._jqObj.find(".tfp-grid-searchbox").show();
          } else {
            $(this.getSearchBoxHtml()).insertBefore(this._jqObj.find(".tfp-grid-datalist"));
          }

          this._jqObj.find(".tfp-grid-datalist").css("top", "50px");
        } else {
          this._jqObj.find(".tfp-grid-searchbox").hide();

          this._jqObj.find(".tfp-grid-datalist").css("top", "0");
        }
      }
    }
  }, {
    key: "allowPaging",
    get: function get() {
      return this.dataModel.allowPaging;
    },
    set: function set(value) {
      this.dataModel.allowPaging = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.allowPaging) {
          if (this._jqObj.find(".tfp-grid-footer").length > 0) {
            this._jqObj.find(".tfp-grid-footer").show();
          } else {
            $(this.getFooterHtml()).insertAfter(this._jqObj.find(".tfp-grid-datalist"));
          }

          this._jqObj.find(".tfp-grid-datalist").css("bottom", "50px");
        } else {
          this._jqObj.find(".tfp-grid-footer").hide();

          this._jqObj.find(".tfp-grid-footer").css("bottom", "0");
        }
      }
    }
  }, {
    key: "containerEl",
    get: function get() {
      return this._jqObj.find(".tfp-grid-datalist").get(0);
    }
  }, {
    key: "deleteCptId",
    value: function deleteCptId(cptHtml) {
      var start = cptHtml.indexOf("id=\"");
      if (start < 0) return cptHtml;
      var end = cptHtml.indexOf("\"", start + 4);
      if (end < 0) return cptHtml;
      cptHtml = cptHtml.substr(0, start) + cptHtml.substr(end + 2);
      return this.deleteCptId(cptHtml);
    }
  }, {
    key: "setCptDataFormat",
    value: function setCptDataFormat(cdm) {
      //let cpt = this._tfp.get(cdm.id);
      if (cdm.dataBindingFormat) {
        cdm.value = cdm.dataBindingFormat;
      }

      if (cdm.components && cdm.components.length > 0) {
        for (var i = 0; i < cdm.components.length; i++) {
          this.setCptDataFormat(cdm.components[i]);
        }
      }
    }
  }, {
    key: "getSearchBoxHtml",
    value: function getSearchBoxHtml() {
      var html = "";

      if (this.showSearchBox) {
        var indent = this.getHtmlIndent();
        var imgUrl = this._tfp.rootPath + "/src/components/grid/images/search.png";
        var readonly = "";
        if (this._tfp.isDesigning) readonly = " readonly";
        html += indent + "\t<div class=\"tfp-grid-searchbox\">" + "<img src=\"" + imgUrl + "\" /><input type=\"text\"" + readonly + ">" + "<label>搜索</label></div>\r\n";
      }

      return html;
    }
  }, {
    key: "getFooterHtml",
    value: function getFooterHtml() {
      var html = "";

      if (this.allowPaging) {
        var indent = this.getHtmlIndent();
        html += indent + "\t<div class=\"tfp-grid-footer\">\r\n";
        html += indent + "\t\t<div style=\"border:0;\"></div>\r\n";
        html += indent + "\t\t<div>首页</div>\r\n";
        html += indent + "\t\t<div>上一页</div>\r\n";
        html += indent + "\t\t<div>下一页</div>\r\n";
        html += indent + "\t\t<div>尾页</div>\r\n";
        html += indent + "\t</div>\r\n";
      }

      return html;
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (!data || !Array.isArray(data)) return;
      this.dataList = data;

      var templateRow = this._jqObj.find(".tfp-griddatarow-template");

      var dataRowHtmlTemplate = templateRow.get(0).outerHTML;
      var rowHeight = templateRow.height();
      dataRowHtmlTemplate = dataRowHtmlTemplate.replace("tfp-griddatarow-template", "tfp-griddatarow");
      var top = 0;

      this._jqObj.find(".tfp-griddatarow").remove();

      var cdmRow = this.dataModel.components[0];

      var dataListDiv = this._jqObj.find(".tfp-grid-datalist");

      for (var i = 0; i < data.length; i++) {
        var rowData = data[i];

        if (cdmRow.beforeBindingData) {
          var eventFucName = tfp.getCptEventFuncName(cdmRow.beforeBindingData);
          rowData = eval(eventFucName + "(rowData)");
        }

        var dataRowHtml = dataRowHtmlTemplate;
        top = i * (rowHeight + 10);

        try {
          dataRowHtml = this._tfp.replaceDataField(rowData, dataRowHtml);
          dataRowHtml = this._tfp.exeExpress(dataRowHtml);
        } catch (e) {
          console.log(e);
          return;
        }

        dataListDiv.append(dataRowHtml);
        var newRow = dataListDiv.find(".tfp-griddatarow").last();
        newRow.css("top", top + "px");

        if (cdmRow.afterBindingData) {
          var _eventFucName = tfp.getCptEventFuncName(cdmRow.afterBindingData);

          eval(_eventFucName + "(newRow, rowData)");
        }
      }

      dataListDiv.get(0).scrollTop = 0;
      if (this.allowPaging) this._jqObj.find(".tfp-grid-footer").find("div").eq(0).html(this.curPage + "/" + this.pageCount);
    }
  }, {
    key: "loadData",
    value: function loadData(toPage) {
      if (!this.dataModel.loadDataService) {
        alert("请为[" + this.id + "]设置加载数据服务！");
        return;
      }

      var serviceCpt = this._tfp.get(this.dataModel.loadDataService);

      if (!serviceCpt) {
        alert("ID为[" + this.dataModel.loadDataService + "]的组件不存在！");
        return;
      }

      if (!this.dataModel.dataBindingMember) {
        alert("请为[" + this.id + "]设置数据绑定成员！");
        return;
      }

      var args = {};

      if (this.allowPaging) {
        args = {
          pageSize: this.pageSize,
          toPage: toPage
        };
      }

      if (this.showSearchBox) {
        var keyword = this._jqObj.find(".tfp-grid-searchbox").find("input").val();

        if (keyword.trim() != "") args.keyword = keyword;
      }

      var that = this;
      serviceCpt.status = 0;
      serviceCpt.request(args, function (req, res) {
        var data = res[that.dataModel.dataBindingMember];
        if (!data) return;

        if (that.allowPaging) {
          that.curPage = data.toPage;
          that.rowsCount = data.rowsCount;
          that.pageCount = data.pageCount;
          that.pageSize = data.pageSize;
          that.bindData(data.rows);
        } else {
          that.bindData(data);
        }
      });
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.find(".tfp-grid-searchbox").find("label").click(function () {
        that.loadData(1);
      });

      if (this.allowPaging) {
        var footerDivs = this._jqObj.find(".tfp-grid-footer").find("div");

        var _that = this;

        footerDivs.eq(1).click(function () {
          _that.loadData(1);
        });
        footerDivs.eq(2).click(function () {
          var prevPage = _that.curPage - 1;
          if (prevPage < 1) prevPage = 1;

          _that.loadData(prevPage);
        });
        footerDivs.eq(3).click(function () {
          var nextPage = _that.curPage + 1;
          if (nextPage > _that.pageCount) nextPage = _that.pageCount;

          _that.loadData(nextPage);
        });
        footerDivs.eq(4).click(function () {
          _that.loadData(_that.pageCount);
        });
      }

      this.loadData(1);
    }
  }]);

  return Grid;
}(_controller.VisibleComponent);

exports["default"] = Grid;