"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _render = _interopRequireDefault(require("../render.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var GridRender = /*#__PURE__*/function (_TFPComponentRender) {
  _inherits(GridRender, _TFPComponentRender);

  var _super = _createSuper(GridRender);

  function GridRender(__tfp, _dataModel, _level) {
    _classCallCheck(this, GridRender);

    return _super.call(this, __tfp, _dataModel, _level);
  }

  _createClass(GridRender, [{
    key: "getBodyHtml",
    value: function getBodyHtml(getComponentsHtml) {
      var showTotal = false;
      var indent = this.getHtmlIndent();
      var htmlHeader = "\r\n" + indent + "\t<div class=\"tfp-grid-header\"{grid-head-display}>\r\n";
      htmlHeader += indent + "\t\t<div class=\"tfp-grid-header-row\" style=\"width:{grid-header-width}px;\">\r\n";
      var htmlRowTemplate = "\t\t\t<div class=\"tfp-grid-datarow tfp-grid-template-row\" style=\"width:{data-row-width};";
      var rowHeight = null;

      if (this.dataModel.rowHeight) {
        rowHeight = this.dataModel.rowHeight.indexOf("px") < 0 ? this.dataModel.rowHeight + "px" : this.dataModel.rowHeight;
        htmlRowTemplate += "height: " + rowHeight + ";line-height:" + rowHeight + ";";
      }

      htmlRowTemplate += "\">\r\n";
      this.cpt.rowWith = 0;
      var columns = this.dataModel.columns;

      if (!columns) {
        columns = [];

        if (this._tfp.isDesigning) {
          //不能直接修改this.columns，以免保存到tfp文件中
          columns = [{
            name: "列标题1",
            width: "100px",
            align: "center"
          }, {
            name: "列标题1",
            width: "100px",
            align: "center"
          }];
        }
      }

      if (this.dataModel.showCheckbox) {
        htmlHeader += indent + "\t\t\t<div style=\"width:30px;\">" + "<input type=\"checkbox\" onclick=\"tfp.get('" + this.dataModel.id + "').checkAll(this)\" style=\"float:left; margin-left:10px; " + "margin-top:12px;\" /></div>\r\n";
        htmlRowTemplate += "\t\t<div class=\"tfp-grid-datarow-checkbox\">" + "<input type=\"checkbox\" /></div>";
        this.cpt.rowWith += 30;
      }

      for (var i = 0; i < columns.length; i++) {
        var col = columns[i];
        htmlHeader += indent + "\t\t\t<div";
        if (col["class"]) htmlHeader += " class=\"" + col["class"] + "\"";
        htmlHeader += " style=\"";
        var colWidth = this.cpt.getColWidth(col.width);
        htmlHeader += "width:" + colWidth + ";"; //TODO 列宽暂不支持百分比的精确计算，只是简单的把%替换掉了

        this.cpt.rowWith += parseInt(colWidth.replace("px", "").replace("%", ""));
        if (col.align && col.align != "center") htmlHeader += "text-align:" + col.align + ";"; //if(col.color) htmlHeader += "color:"+col.color+";"
        //if(col.bgColor) htmlHeader += "background-color:"+col.bgColor+";"
        //if(col.bold) htmlHeader += "font-weight: bold;"
        //if(col.fontSize) htmlHeader += "font-size: "+col.fontSize+";"
        //if(col.style) htmlHeader += col.style;

        htmlHeader += "\">" + col.name + "</div>\r\n";
        if (col.sum) showTotal = true;
        htmlRowTemplate += "\t\t\t\t<div";
        if (col["class"]) htmlRowTemplate += " class=\"" + col["class"] + "\"";
        htmlRowTemplate += " style=\"width:" + colWidth + ";";
        if (rowHeight) htmlRowTemplate += "height: " + rowHeight + ";";
        if (col.align) htmlRowTemplate += "text-align:" + col.align + ";";
        if (col.color) htmlRowTemplate += "color:" + col.color + ";";
        if (col.bgColor) htmlRowTemplate += "background-color:" + col.bgColor + ";";
        if (col.bold) htmlRowTemplate += "font-weight: bold;";
        if (col.fontSize) htmlRowTemplate += "font-size: " + col.fontSize + ";";
        if (col.onclick) htmlRowTemplate += "cursor: pointer;";
        if (col.style) htmlRowTemplate += col.style;
        htmlRowTemplate += "\">";
        if (col.format) htmlRowTemplate += col.format;
        htmlRowTemplate += "</div>\r\n";
      }

      htmlHeader += indent + "\t\t</div>\r\n";
      htmlHeader += indent + "\t</div>\r\n";
      htmlHeader = htmlHeader.replace("{grid-header-width}", this.cpt.rowWith);
      var html = "";

      if (this.dataModel.showHeader) {
        html += htmlHeader.replace("{grid-head-display}", "");
      } else if (this._tfp.isDesigning) {
        html += htmlHeader.replace("{grid-head-display}", " style=\"display:none;\"");
      }

      htmlRowTemplate += "\t\t\t</div>\r\n";
      htmlRowTemplate = htmlRowTemplate.replace("{data-row-width}", this.cpt.rowWith);
      html += indent + "\t<div class=\"tfp-grid-datalist\" style=\"bottom:{data-list-bottom}px;\">\r\n";
      if (this._tfp.isDesigning) html += htmlRowTemplate;
      html += indent + "\t</div>\r\n";
      var dataListBottom = 0;

      if (showTotal) {
        html += indent + "\t<div class=\"tfp-grid-total\">\r\n";
        html += indent + "\t</div>\r\n";
        dataListBottom += 41;
      }

      html += this.cpt.getFooterHtml();
      if (this.dataModel.showFooter) dataListBottom += 51;
      html = html.replace("{data-list-bottom}", dataListBottom);
      return html;
    }
  }, {
    key: "getHtml",
    value: function getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
      return _get(_getPrototypeOf(GridRender.prototype), "getHtml", this).call(this, "div", getComponentsHtml, parentIndent, retainStyleAttr);
    }
  }]);

  return GridRender;
}(_render["default"]);

exports["default"] = GridRender;