"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Iframe",
  "comment": "嵌入框架",
  "attrs": [{
    "name": "src",
    "comment": "页面路径",
    "type": "String",
    "isHtmlAttr": true
  }, {
    "name": "scrolling",
    "comment": "滚动条",
    "isHtmlAttr": true,
    "type": "Select",
    "options": [{
      "value": "yes",
      "text": "显示"
    }, {
      "value": "no",
      "text": "不显示"
    }, {
      "value": "auto",
      "text": "自动"
    }]
  }, {
    "name": "frameBorder",
    "comment": "边框宽度",
    "type": "Int",
    "isHtmlAttr": true,
    "default": 0
  }, {
    "name": "marginWidth",
    "comment": "边距宽度",
    "type": "Int",
    "isHtmlAttr": true,
    "default": 0
  }, {
    "name": "marginHeight",
    "comment": "边距高度",
    "type": "Int",
    "isHtmlAttr": true,
    "default": 0
  }],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "position": "relative",
    "left": 0,
    "top": 0,
    "width": "300px",
    "height": "240px",
    "border-color": "#CCCCCC",
    "border-width": "1px",
    "border-style": "solid",
    "background-color": "#FFFFFF"
  },
  "events": []
};
exports["default"] = _default;