"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * 组织结构组件
 * @param {[type]} dataModel [description]
 */
var Org = /*#__PURE__*/function (_FormInput) {
  _inherits(Org, _FormInput);

  var _super = _createSuper(Org);

  function Org(__tfp, inputType, dataModel, parent) {
    _classCallCheck(this, Org);

    return _super.call(this, __tfp, inputType, dataModel, parent);
  }

  _createClass(Org, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj) {
        this._jqObj.find("input").val(value);
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
  }, {
    key: "iconUrl",
    get: function get() {
      return this._tfp.rootPath + "/src/components/" + this.dataModel.type.toLowerCase() + "/images/icon-24-" + this._tfp.curPage.contentColorMode + ".png";
    },
    set: function set(value) {}
  }, {
    key: "showIcon",
    get: function get() {
      return this.dataModel.showIcon;
    },
    set: function set(value) {
      this.dataModel.showIcon = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.showIcon) {
          if (this._jqObj.find("img").length == 0) {
            this._jqObj.append("<img src=\"" + this.iconUrl + "\" />");
          }
        } else {
          this._jqObj.find("img").remove();
        }

        var iptWidth = "100%";
        if (this.dataModel.showIcon) iptWidth = "calc(100% - 30px)";

        this._jqObj.find("input").css("width", iptWidth + "px");
      }
    }
  }, {
    key: "valueType",
    get: function get() {
      return this.dataModel.valueType;
    },
    set: function set(value) {
      if (!this.checkAttrOption("valueType", value)) {
        this._tfp.showMsg("不支持类型：" + value + "！");

        return;
      }

      this.dataModel.valueType = value;
    }
  }, {
    key: "multiCheck",
    get: function get() {
      return this.dataModel.multiCheck;
    },
    set: function set(value) {
      this.dataModel.multiCheck = value ? true : false;
    }
  }, {
    key: "showPicker",
    value: function showPicker() {
      if (this.dataModel.type == "Dep") {
        if (this.dataModel.multiCheck) {
          this._tfp.openDialog("选择部门", this._tfp.rootPath + "/src/components/org/tfp/depsPicker.tfp?valueType=obj&cptId=" + this.id, "480px", "480px");
        } else {
          this._tfp.openDialog("选择部门", this._tfp.rootPath + "/src/components/org/tfp/depPicker.tfp?valueType=obj&cptId=" + this.id, "480px", "480px");
        }
      } else if (this.dataModel.type == "User") {
        if (this.dataModel.multiCheck) {
          this._tfp.openDialog("选择用户", this._tfp.rootPath + "/src/components/org/tfp/usersPicker.tfp?valueType=obj&cptId=" + this.id, "480px", "480px");
        } else {
          this._tfp.openDialog("选择用户", this._tfp.rootPath + "/src/components/org/tfp/userPicker.tfp?valueType=obj&cptId=" + this.id, "480px", "480px");
        }
      } else if (this.dataModel.type == "Role") {
        if (this.dataModel.multiCheck) {
          this._tfp.openDialog("选择群组", this._tfp.rootPath + "/src/components/org/tfp/rolesPicker.tfp?valueType=obj&cptId=" + this.id, "480px", "480px");
        } else {
          this._tfp.openDialog("选择群组", this._tfp.rootPath + "/src/components/org/tfp/rolePicker.tfp?valueType=obj&cptId=" + this.id, "480px", "480px");
        }
      }
    }
  }, {
    key: "onSelected",
    value: function onSelected(ret) {
      if (this.dataModel.valueType == "obj") {
        this.value = ret;
      } else {
        if (this.dataModel.multiCheck) {
          var val = "";

          for (var i = 0; i < ret.length; i++) {
            if (val != "") val += ",";
            val += ret[i].id;
          }

          this.value = val;
        } else {
          this.value = ret.id;
        }
      }

      if (this.dataModel.multiCheck) {
        var names = "";

        for (var i = 0; i < ret.length; i++) {
          if (names != "") names += ",";
          names += ret[i].name;
        }

        this._jqObj.find("input").val(names);
      } else {
        this._jqObj.find("input").val(ret.name);
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.click(function () {
        if (that.readonly || that.disabled) return;
        that.showPicker();
      });
    }
  }]);

  return Org;
}(_controller.FormInput);

exports["default"] = Org;