"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var Page = /*#__PURE__*/function (_ContainerComponent) {
  _inherits(Page, _ContainerComponent);

  var _super = _createSuper(Page);

  function Page(__tfp, dataModel) {
    var _this;

    _classCallCheck(this, Page);

    _this = _super.call(this, __tfp, "Page", dataModel);

    if (__tfp.isRuntime) {
      if (dataModel.pageElId) {
        _this._jqObj = $("#" + dataModel.pageElId);
      } else {
        _this._jqObj = $("body");
      }

      _this.el = _this._jqObj.get(0);
      if (_this.dataModel.title) $("title").text(_this.dataModel.title); //初始化页面样式

      if (_this.dataModel.styles) {
        for (var style in _this.dataModel.styles) {
          _this._jqObj.css(style, _this.dataModel.styles[style]);
        }
      }
    }

    return _this;
  }

  _createClass(Page, [{
    key: "client",
    get: function get() {
      return this.dataModel.client;
    }
  }, {
    key: "positionType",
    get: function get() {
      return this.dataModel.positionType;
    }
  }, {
    key: "framework",
    get: function get() {
      return this.dataModel.framework;
    }
  }, {
    key: "pageType",
    get: function get() {
      return this.dataModel.pageType;
    }
  }, {
    key: "cssFiles",
    get: function get() {
      return this.dataModel.cssFiles;
    },
    set: function set(value) {
      this.dataModel.cssFiles = value;
    }
  }, {
    key: "jsFiles",
    get: function get() {
      return this.dataModel.jsFiles;
    },
    set: function set(value) {
      this.dataModel.jsFiles = value;
    }
  }, {
    key: "styleSheets",
    get: function get() {
      return this.dataModel.styleSheets;
    },
    set: function set(value) {
      this.dataModel.styleSheets = value;
    }
  }, {
    key: "title",
    get: function get() {
      return this.dataModel.title;
    },
    set: function set(value) {
      this.dataModel.title = value;
      $("title").text(value);

      if (this._tfp.isDesigning) {
        if (this.client == "phone") {
          window.parent.$("#divPhonePageTitle").html(value);
        } else if (this.pageType == "dialog") {
          window.parent.$("#uiDesignerPageTitle").html("&nbsp;&nbsp;" + value);
        }
      }
    }
    /**
     * 背景颜色模式
     */

  }, {
    key: "bgColorMode",
    get: function get() {
      return this.dataModel.bgColorMode;
    },
    set: function set(value) {
      this.dataModel.bgColorMode = value;
    }
    /**
     * 内容颜色模式，与背景相反
     */

  }, {
    key: "contentColorMode",
    get: function get() {
      return this.dataModel.bgColorMode == "dark" ? "light" : "dark";
    },
    set: function set(value) {}
  }, {
    key: "width",
    get: function get() {
      return this.dataModel.pageType == "dialog" ? this.dataModel.width : null;
    },
    set: function set(value) {
      if (!value || this.dataModel.pageType != "dialog") return;
      this.dataModel.width = value;

      var _width = value + "";

      if (_width.indexOf("px") < 0 && _width.indexOf("%") < 0) {
        _width += "px";
      } //设置设计和运行时宽度


      if (this._tfp.isDesigning && this.pageType == "dialog") {
        window.parent.$("#uiDesignerFrame").css("width", _width);
        window.parent.$("#uiDesignerFrame").find("iframe").css("width", _width);
      } else if (this._tfp.isRuntime) {//
      }
    }
  }, {
    key: "height",
    get: function get() {
      return this.dataModel.pageType == "dialog" ? this.dataModel.height : null;
    },
    set: function set(value) {
      if (!value || this.dataModel.pageType != "dialog") return;
      this.dataModel.height = value;

      var _height = value + "";

      if (_height.indexOf("px") < 0 && _height.indexOf("%") < 0) {
        _height += "px";
      } //TODO 设置设计和运行时宽度


      if (this._tfp.isDesigning && this.pageType == "dialog") {
        window.parent.$("#uiDesignerFrame").css("height", _height);
        window.parent.$("#uiDesignerFrame").find("iframe").css("height", parseInt(_height.replace("px", "")) - 31 + "px");
      } else if (this._tfp.isRuntime) {//
      }
    }
  }, {
    key: "render",
    value: function render() {
      _get(_getPrototypeOf(Page.prototype), "render", this).call(this);

      if (this._tfp.isDesigning) {
        if (this.dataModel.style) {
          $("body").attr("style", this.dataModel.style);
        }

        if (this.dataModel.styles) {
          var styles = "";

          for (var styleName in this.dataModel.styles) {
            $("body").css(styleName, this.dataModel.styles[styleName]);
          }
        }

        if (this.dataModel["class"]) {
          $("body").attr("class", this.dataModel["class"]);
        }

        if (this.dataModel.styleSheets) {
          var styleCode = "";

          for (var i = 0; i < this.dataModel.styleSheets.length; i++) {
            var styleSheet = this.dataModel.styleSheets[i];
            styleCode += "\t" + styleSheet.id + " {";

            for (var j = 0; j < styleSheet.styles.length; j++) {
              var style = styleSheet.styles[j];
              styleCode += style.name + ": " + style.value + ";";
            }

            styleCode += "}\r\n";
          }

          $("head").append("<style id=\"_tfpPageStyleSetting\">\r\n" + styleCode + "</style>");
        }

        if (this.dataModel.cssFiles) {
          for (var i = 0; i < this.dataModel.cssFiles.length; i++) {
            var cssFile = this.dataModel.cssFiles[i];
            $("head").append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + cssFile + "\">");
          }
        }
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      if (this.dataModel["onLoad"]) {
        eval(this.dataModel["onLoad"]);
      }
    }
  }]);

  return Page;
}(_controller.ContainerComponent);

exports["default"] = Page;