"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Page",
  "comment": "页面",
  "attrs": [{
    "name": "common",
    "comment": "页面信息",
    "type": "group",
    "items": [{
      "name": "client",
      "comment": "终端类型",
      "type": "Select",
      "readonly": true,
      "options": [{
        "value": "pc",
        "text": "电脑端"
      }, {
        "value": "phone",
        "text": "手机端"
      }]
    }, {
      "name": "positionType",
      "comment": "组件默认定位方式",
      "type": "Select",
      "readonly": true,
      "options": [{
        "value": "float",
        "text": "浮动定位"
      }, {
        "value": "absolute",
        "text": "绝对定位"
      }]
    }, {
      "name": "framework",
      "comment": "前端UI框架",
      "type": "String",
      "readonly": true
    }, {
      "name": "pageType",
      "comment": "页面类型",
      "type": "Select",
      "readonly": true,
      "options": [{
        "value": "page",
        "text": "普通页面"
      }, {
        "value": "dialog",
        "text": "弹出窗口"
      }]
    }, {
      "name": "title",
      "comment": "标题",
      "type": "String"
    }, {
      "name": "bgColorMode",
      "comment": "页面背景颜色模式",
      "type": "Select",
      "options": [{
        "value": "light",
        "text": "浅色背景"
      }, {
        "value": "dark",
        "text": "深色背景"
      }],
      "default": "light"
    }]
  }, {
    "name": "dialog",
    "comment": "对话框属性",
    "type": "group",
    "hidden": "'{pageType}'=='page'",
    "items": [{
      "name": "width",
      "comment": "宽度",
      "type": "String"
    }, {
      "name": "height",
      "comment": "高度",
      "type": "String"
    }]
  }],
  "styles": ["font", "background", "margin", "border"],
  "events": [{
    "name": "onLoad",
    "comment": "页面加载时"
  }, {
    "name": "onClick",
    "comment": "点击页面时"
  }]
};
exports["default"] = _default;