"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * 单选框组件
 * @param {[type]} dataModel [description]
 */
var Radio = /*#__PURE__*/function (_FormInput) {
  _inherits(Radio, _FormInput);

  var _super = _createSuper(Radio);

  function Radio(__tfp, dataModel, parent) {
    _classCallCheck(this, Radio);

    return _super.call(this, __tfp, "Radio", dataModel, parent);
  } //属性


  _createClass(Radio, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj) {
        this._jqObj.find(".tfp-radio-box").each(function () {
          if ($(this).attr("data-option") == value) {
            $(this).find("div").css("display", "inline-block");
          } else {
            $(this).find("div").css("display", "none");
          }
        });
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
  }, {
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(value) {
      if (!value) return;
      this.setOptions(value);

      if (this._jqObj) {
        this._jqObj.empty();

        for (var i = 0; i < value.length; i++) {
          this.addOption(value[i], true);
        }
      }
    }
  }, {
    key: "portrait",
    get: function get() {
      return this.dataModel.portrait;
    },
    set: function set(value) {
      this.dataModel.portrait = value ? true : false;

      if (this._jqObj) {
        if (value) {
          var that = this;

          this._jqObj.find("label").each(function (index) {
            if (index < that._jqObj.find("label").length - 1) {
              $("<br/>").insertAfter($(this));
            }
          });
        } else {
          this._jqObj.find("br").remove();
        }
      }
    }
  }, {
    key: "getOptionHtml",
    value: function getOptionHtml(indent, option) {
      var optionHtml = "";
      var optionDisplay = "none";
      if (this.value == option.value) optionDisplay = "inline-block";
      var disabledStyle = "";
      if (this.dataModel.disabled) disabledStyle = " style=\"background-color:#eeeeee;\"";
      optionHtml += indent + "\t<div class=\"tfp-radio-box\" " + disabledStyle + " data-option=\"" + option.value + "\">" + "<div style=\"display:" + optionDisplay + ";\"></div></div>";

      if (option.text) {
        optionHtml += "<label>" + option.text + "</label>\r\n";
      } else {
        optionHtml += "<label>" + option.value + "</label>\r\n";
      }

      return optionHtml;
    }
  }, {
    key: "addOption",
    value: function addOption(option, isInit) {
      var indent = this.getHtmlIndent();
      var str = "";
      if (this.portrait && this._jqObj.children().length > 0) str += indent + "\t<br>\r\n";
      str += this.getOptionHtml(indent, option);

      if (str != "") {
        this._jqObj.append(str);

        if (!isInit) this.dataModel.options.push(option);
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.find(".tfp-radio-box").each(function () {
        $(this).click(function () {
          if (that.dataModel.disabled) return;
          that.value = $(this).attr("data-option");
        });
      });
    }
  }]);

  return Radio;
}(_controller.FormInput);

exports["default"] = Radio;