"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var TFPComponentRender = /*#__PURE__*/function () {
  function TFPComponentRender(__tfp, _dataModel, _level) {
    _classCallCheck(this, TFPComponentRender);

    if (!__tfp) {
      throw new Error("请提供tfp对象！");
      return;
    }

    if (!_dataModel) {
      throw new Error("请提供组件数据模型！");
      return;
    }

    this._tfp = __tfp;
    this.dataModel = _dataModel;
    this.metadata = this._tfp.type(this.dataModel.type);
    this.level = 0; //组件相对页面组件的层次

    if (_level) this.level = _level;
  }

  _createClass(TFPComponentRender, [{
    key: "cpt",
    get: function get() {
      return this._tfp.components[this.dataModel.id];
    }
  }, {
    key: "isContainer",
    get: function get() {
      return this._tfp.components[this.dataModel.id].isContainer;
    }
  }, {
    key: "getHtmlIndent",
    value: function getHtmlIndent() {
      return this.cpt.getHtmlIndent();
    }
  }, {
    key: "getAttrHtml",
    value: function getAttrHtml() {
      var attrHtml = "";
      var attrs = this.metadata.attrs;
      var arrAttr = [];

      for (var _i = 0; _i < attrs.length; _i++) {
        var attrInfo = attrs[_i];

        if (attrInfo.type == "group") {
          for (var j = 0; j < attrInfo.items.length; j++) {
            arrAttr.push(attrInfo.items[j]);
          }
        } else {
          arrAttr.push(attrInfo);
        }
      }

      for (var _i2 = 0; _i2 < arrAttr.length; _i2++) {
        var _attrInfo = arrAttr[_i2];

        if (_attrInfo.isHtmlAttr && _attrInfo.name in this.dataModel) {
          var attrVal = this.dataModel[_attrInfo.name];
          if (!(attrVal || attrVal == 0 || attrVal == false)) continue; //如果是特殊属性，则调用自定义方法获得属性html

          if (_attrInfo.special && this.getCustomAttrHtml) {
            attrHtml += this.getCustomAttrHtml(_attrInfo.name);
            continue;
          } //设计时组件不能禁用，否则无法点击获得焦点


          if (this._tfp.isDesigning && _attrInfo.name == "disabled") continue;

          if (_attrInfo.name == "disabled" || _attrInfo.name == "readonly") {
            attrHtml += " " + _attrInfo.name;
            if (attrVal == false || attrVal == "false") attrHtml += "=\"false\"";
          } else {
            //HTML标签的属性名必须小写
            attrHtml += " " + _attrInfo.name.toLowerCase() + "=\"" + this.dataModel[_attrInfo.name] + "\"";
          }
        }
      } //事件


      if (!this._tfp.isDesigning && this.metadata.events) {
        for (var i = 0; i < this.metadata.events.length; i++) {
          var eventInfo = this.metadata.events[i]; //input type=text 的onchange事件在代码里修改值不会触发，需要在各个组件里处理
          //页面加载事件不能直接写在body标签的属性里，因为需要等tfp组件解析完毕

          if (eventInfo.name.toLowerCase() == "onchange" || this.cpt.type == "Page" && eventInfo.name.toLowerCase() == "onload") continue;

          for (var propName in this.dataModel) {
            //事件名称忽略大小写
            if (eventInfo.name.toLowerCase() == propName.toLowerCase()) {
              var eventFunc = this.dataModel[propName];
              if (eventFunc.indexOf("(") < 0 || eventFunc.indexOf(")") < 0) eventFunc += "()";
              attrHtml += " " + eventInfo.name.toLowerCase() + "=\"" + eventFunc + "\"";
              break;
            }
          }
        }
      }

      return attrHtml;
    }
  }, {
    key: "getStyleHtml",
    value: function getStyleHtml(isGetHead, retainStyleAttr) {
      var styleHtml = "";

      if (this.dataModel.styles) {
        for (var styleName in this.dataModel.styles) {
          styleHtml += " " + styleName + ":" + this.dataModel.styles[styleName] + ";";
        }
      }

      if (this.dataModel.style) styleHtml += this.dataModel.style;
      if (this.getCustomStyleHtml) styleHtml += this.getCustomStyleHtml();

      if (this._tfp.isDesigning) {
        styleHtml += "user-select:none;"; //设计时，如果容器组件没有设置边框，则为其添加一个轮廓线，以便查看
        //不能直接设置border样式，因为会造成面板组件的内容宽度和高度与实际不一致
        //导致设计时可能会出现滚动条，而实际运行时没有

        if ((this.isContainer || this.dataModel.components) && styleHtml.indexOf("border:") < 0 && styleHtml.indexOf("border-width:") < 0) styleHtml += "outline:#cccccc dashed 1px;";
      } //如果是在后台编译时获得样式信息，则将组件样式抽取到页面头部style标签中，以便统一查看


      if (isGetHead) {//
      } else if (this._tfp.isDesigning || retainStyleAttr) {
        styleHtml = " style=\"" + styleHtml + " \"";
      } else {
        styleHtml = "";
      }

      return styleHtml;
    }
  }, {
    key: "getComponentsHtml",
    value: function getComponentsHtml(_getComponentsHtml, indent, retainStyleAttr) {
      var html = "";
      if (!indent) indent = "";

      for (var i = 0; i < this.dataModel.components.length; i++) {
        var cdm = this.dataModel.components[i];
        var Render = this._tfp.renders[cdm.type];
        if (!Render) continue;
        var render = new Render(this._tfp, cdm, this.level + 1);
        html += render.getHtml(_getComponentsHtml, indent, retainStyleAttr);
      }

      return html;
    }
  }, {
    key: "getHtml",
    value: function getHtml(tagName, getComponentsHtml, parentIndent, retainStyleAttr) {
      if (!tagName) return "";
      var indent = this.getHtmlIndent(); //有些容器组件由多级html元素构成，他们子组件的代码缩进
      //需要根据父组件的容器元素的代码缩进进行相应的增加

      if (parentIndent) {
        indent = parentIndent + "\t";
        this.indent = indent;
      }

      var cptHtml = indent + "<" + tagName + " id=\"" + this.dataModel.id + "\" class=\"tfp-" + this.dataModel.type.toLowerCase().replace("_", "-");
      if (this.getSpecialClass) cptHtml += this.getSpecialClass();
      if (this.dataModel["class"]) cptHtml += " " + this.dataModel["class"];
      cptHtml += "\"" + this.getAttrHtml() + this.getStyleHtml(false, retainStyleAttr);

      if (this.getBodyHtml) {
        cptHtml += ">";
        cptHtml += this.getBodyHtml(getComponentsHtml, retainStyleAttr);
        cptHtml += "</" + tagName + ">\r\n";
      } else if (this.isContainer || this.dataModel.components) {
        cptHtml += ">\r\n";

        if (getComponentsHtml && this.dataModel.components) {
          cptHtml += this.getComponentsHtml(getComponentsHtml, indent, retainStyleAttr);
        }

        cptHtml += indent + "</" + tagName + ">\r\n";
      } else {
        cptHtml += "/>\r\n";
      } //if(this.dataModel.type=="Button") console.log(cptHtml);


      return cptHtml;
    }
  }]);

  return TFPComponentRender;
}();

exports["default"] = TFPComponentRender;