"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * 列表组件
 * @param {[type]} dataModel [description]
 */
var Select = /*#__PURE__*/function (_FormInput) {
  _inherits(Select, _FormInput);

  var _super = _createSuper(Select);

  function Select(__tfp, dataModel, parent) {
    _classCallCheck(this, Select);

    return _super.call(this, __tfp, "Select", dataModel, parent);
  } //属性


  _createClass(Select, [{
    key: "value",
    get: function get() {
      if (!this.dataModel.value) return "";
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj && this.dataModel.options) {
        for (var i = 0; i < this.dataModel.options.length; i++) {
          var option = this.dataModel.options[i];

          if (option.value == value) {
            this._jqObj.val(option.text != null && option.text != undefined ? option.text : option.value);

            break;
          }
        }
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
  }, {
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(value) {
      this.dataModel.options = value;
    }
  }, {
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    }
  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    }
  }, {
    key: "valueField",
    get: function get() {
      return this.dataModel.valueField;
    },
    set: function set(value) {
      this.dataModel.valueField = value;
    }
  }, {
    key: "textField",
    get: function get() {
      return this.dataModel.textField;
    },
    set: function set(value) {
      this.dataModel.textField = value;
    }
  }, {
    key: "addOption",
    value: function addOption(option) {
      if (!this.dataModel.options) this.dataModel.options = [];
      this.dataModel.options.push(option);
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (isNull(data) || !Array.isArray(data)) return;
      this.dataModel.options = [];

      for (var i = 0; i < data.length; i++) {
        var row = data[i];
        var option = {};

        try {
          option.value = this._tfp.replaceDataField(row, "{" + this.dataModel.valueField + "}");
        } catch (e) {
          console.log(e);
          return;
        }

        if (isNull(option.value)) continue;

        if (this.dataModel.textField) {
          try {
            option.text = this._tfp.replaceDataField(row, "{" + this.dataModel.textField + "}");
          } catch (e) {
            console.log(e);
            return;
          }
        }

        this.dataModel.options.push(option); //显示组件当前值对应的文本

        if (option.value == this.dataModel.value && this._jqObj) {
          if (option.text) {
            this._jqObj.val(option.text);
          } else {
            this._jqObj.val(option.value);
          }
        }
      }
    }
  }, {
    key: "loadData",
    value: function loadData() {
      if (!this.dataModel.loadDataService) {
        alert("请为[" + this.id + "]设置加载数据服务！");
        return;
      }

      var serviceCpt = this._tfp.get(this.dataModel.loadDataService);

      if (!serviceCpt) {
        alert("ID为[" + this.dataModel.loadDataService + "]的组件不存在！");
        return;
      }

      if (!this.dataModel.dataBindingMember) {
        alert("请为[" + this.id + "]设置数据绑定成员！");
        return;
      }

      if (!this.dataModel.valueField) {
        alert("请为[" + this.id + "]设置选项值字段格式！");
        return;
      }

      var that = this;
      serviceCpt.request(null, function (req, res) {
        var data = res[that.dataModel.dataBindingMember];
        that.bindData(data);
      });
    }
  }, {
    key: "showPopupList",
    value: function showPopupList() {
      var that = this;
      window.popupList.show([{
        options: this.dataModel.options,
        value: this.dataModel.value
      }], function (vals) {
        if (vals.length > 0) that.value = vals[0];
      });
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      if (this.dataModel.loadDataService) {
        this.loadData();
      }

      var that = this;

      this._jqObj.click(function () {
        if (!window.popupList) {
          that._tfp.use(["PopupList"], function () {
            var popupListClass = that._tfp.controllers["PopupList"];
            window.popupList = new popupListClass(that._tfp, {
              "id": "popupList",
              "type": "PopupList"
            });
            that.showPopupList();
          });

          return;
        }

        that.showPopupList();
      });
    }
  }]);

  return Select;
}(_controller.FormInput);

exports["default"] = Select;