"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * 选项卡组件
 * @param {[type]} dataModel [description]
 */
var Tab = /*#__PURE__*/function (_ContainerComponent) {
  _inherits(Tab, _ContainerComponent);

  var _super = _createSuper(Tab);

  function Tab(__tfp, dataModel, parent) {
    var _this;

    _classCallCheck(this, Tab);

    _this = _super.call(this, __tfp, "Tab", dataModel, parent);

    if (!_this.dataModel.components || _this.dataModel.components.length == 0) {
      _this.dataModel.components = [{
        id: _this.id + "_page1",
        type: "TabPage",
        title: "page1"
      }, {
        id: _this.id + "_page2",
        type: "TabPage",
        title: "page2",
        styles: {
          display: "none"
        }
      }];
    }

    return _this;
  }

  _createClass(Tab, [{
    key: "pages",
    get: function get() {
      var pages = [];

      for (var i = 0; i < this.dataModel.components.length; i++) {
        var tabPageDM = this.dataModel.components[i];
        pages.push({
          id: tabPageDM.id,
          type: "TabPage",
          title: tabPageDM.title
        });
      }

      return pages;
    },
    set: function set(value) {
      var pages = [];
      if (value) pages = value;
      var tabPages = [];
      if (this.dataModel.pageIndex >= pages.length) this.dataModel.pageIndex = pages.length - 1;
      if (this.dataModel.pageIndex < 0) this.dataModel.pageIndex = 0;

      for (var i = 0; i < pages.length; i++) {
        var page = pages[i];
        var cdm = null;

        if (page.id) {
          var tabPage = this._tfp.components[page.id];
          cdm = tabPage.dataModel;
          cdm.title = page.title;
          if (cdm.styles && cdm.styles.display) delete cdm.styles["display"];
          delete this._tfp.components[tabPage.id];
        } else {
          cdm = {
            type: "TabPage",
            title: page.title
          };
        }

        if (i != this.dataModel.pageIndex) {
          if (cdm.styles) {
            cdm.styles.display = "none";
          } else {
            cdm.styles = {
              display: "none"
            };
          }
        }

        tabPages.push(cdm);
      }

      this.dataModel.components = tabPages;

      this._jqObj.remove();

      this.render();
      if (this.dataModel.components.length > 0) this.showTabPage(0);
    }
  }, {
    key: "pageIndex",
    get: function get() {
      return this.dataModel.pageIndex;
    },
    set: function set(value) {
      this.dataModel.pageIndex = value;
      if (this._jqObj) this.showTabPage(value);
    }
  }, {
    key: "titleWidth",
    get: function get() {
      return this.dataModel.titleWidth;
    },
    set: function set(value) {
      this.dataModel.titleWidth = value;

      if (this._jqObj) {
        this._jqObj.find(".tfp-tab-head").css("width", value);
      }
    }
  }, {
    key: "titleHeight",
    get: function get() {
      return this.dataModel.titleHeight;
    },
    set: function set(value) {
      this.dataModel.titleHeight = value;

      if (this._jqObj) {
        this._jqObj.find(".tfp-tab-head").css("height", value);
      }
    }
  }, {
    key: "containerEl",
    get: function get() {
      return this._jqObj.find(".tfp-tab-pages").get(0);
    }
  }, {
    key: "showTabPage",
    value: function showTabPage(index) {
      this._jqObj.find(".tfp-tabpage").hide();

      this._jqObj.find(".tfp-tab-title").removeClass("tfp-tab-title-selected");

      this._jqObj.find(".tfp-tabpage").eq(index).show();

      this._jqObj.find(".tfp-tab-title").eq(index).addClass("tfp-tab-title-selected");

      if (!this._tfp.isDesigning) {
        this.dataModel.pageIndex = index;

        for (var i = 0; i < this.dataModel.components.length; i++) {
          var tabPageDM = this.dataModel.components[i];

          if (i == index) {
            if (tabPageDM.styles) delete tabPageDM.styles["display"];
          } else {
            if (!tabPageDM.styles) tabPageDM.styles = {};
            tabPageDM.styles["display"] = "none";
          }
        }
      } //this.exeEventHandler("onTabIndexChange");


      if (this.dataModel.onTabIndexChange && !this._tfp.isDesigning) eval(this.dataModel.onTabIndexChange); //window.event.stopPropagation();
    }
  }]);

  return Tab;
}(_controller.ContainerComponent);

exports["default"] = Tab;