"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Tab",
  "comment": "选项卡",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [{
    "name": "pages",
    "comment": "选项页集合",
    "type": "Dataset",
    "special": true,
    "columns": [{
      "id": "id",
      "name": "ID",
      "type": "String",
      "width": "150px",
      "readonly": true
    }, {
      "id": "title",
      "name": "标题",
      "type": "String",
      "width": "200px",
      "required": true
    }]
  }, {
    "name": "pageIndex",
    "comment": "当前选项页索引",
    "type": "Int",
    "special": true,
    "default": 0
  }, {
    "name": "titleWidth",
    "comment": "选项页标题宽度",
    "type": "Int",
    "required": true,
    "default": 150
  }, {
    "name": "titleHeight",
    "comment": "选项页标题高度",
    "type": "Int",
    "required": true,
    "default": 40
  }],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "302px",
    "height": "150px",
    "position": "relative",
    "left": 0,
    "top": 0
  },
  "methods": [{
    "name": "showTabPage",
    "comment": "显示指定索引的选项页",
    "args": [{
      "name": "index",
      "comment": "索引",
      "type": "Int",
      "required": true
    }]
  }],
  "events": [{
    "name": "onClick",
    "comment": "点击时"
  }, {
    "name": "onMouseOver",
    "comment": "鼠标经过时"
  }, {
    "name": "onMouseOut",
    "comment": "鼠标移出时"
  }, {
    "name": "onAddTabPage",
    "comment": "添加选项页时"
  }, {
    "name": "onDelTabPage",
    "comment": "删除选项页时"
  }, {
    "name": "onTabIndexChange",
    "comment": "选中页变化时"
  }]
};
exports["default"] = _default;