"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * 单行文本组件
 * @param {[type]} dataModel [description]
 */
var Text = /*#__PURE__*/function (_FormInput) {
  _inherits(Text, _FormInput);

  var _super = _createSuper(Text);

  function Text(__tfp, dataModel, parent, inputType) {
    var _this;

    _classCallCheck(this, Text);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "Text", dataModel, parent);
    }

    return _possibleConstructorReturn(_this);
  }

  _createClass(Text, [{
    key: "value",
    get: function get() {
      if (!this.dataModel.value) return "";
      return this.dataModel.value;
    },
    set: function set(value) {
      var val = value;

      if (isNull(value)) {
        val = "";
        this.dataModel.value = null;
      } else {
        //如果设置了计算公式，则需要替换掉金额里的逗号
        if (this.dataModel.formula) {
          val = (val + "").trim().replaceAll(",", "");
          if (isNaN(val)) return;
        }

        try {
          if (this.dataModel.dataType == "int") {
            val = parseInt(val);
          } else if (this.dataModel.dataType == "float") {
            val = parseFloat(val);
          } else if (this.dataModel.dataType == "money") {
            val = this._tfp.formatMoney(val, 2);
          }
        } catch (err) {
          console.error(err.message); //this._tfp.showMsg(err.message);

          return;
        }

        this.dataModel.value = val;
      }

      if (this._jqObj) {
        this._jqObj.val(val);
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", val);
      }
    }
  }, {
    key: "maxLength",
    get: function get() {
      return this.dataModel.maxLength;
    },
    set: function set(value) {
      this.dataModel.maxLength = value;
      if (this._jqObj) this._jqObj.attr("maxlength", value);
    }
  }, {
    key: "placeHolder",
    get: function get() {
      return this.dataModel.placeHolder;
    },
    set: function set(value) {
      this.dataModel.placeHolder = value;
      if (this._jqObj) this._jqObj.attr("placeholder", value);
    }
  }, {
    key: "dataType",
    get: function get() {
      if (!this.dataModel.dataType) this.dataModel.dataType = "text";
      return this.dataModel.dataType;
    },
    set: function set(value) {
      this.dataModel.dataType = value;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.blur(function () {
        var val = $(this).val().trim();

        if (!isNull(val)) {
          if (that.dataModel.dataType && that.dataModel.dataType != "text") {
            if (isNaN(val)) {
              $(this).focus();
              return;
            }
          }

          try {
            if (that.dataModel.dataType == "int") {
              if (!isInt(val)) {
                $(this).focus();
                return;
              }

              val = parseInt(val);
            } else if (that.dataModel.dataType == "float") {
              val = parseFloat(val);
            } else if (that.dataModel.dataType == "money") {
              val = that._tfp.formatMoney(val, 2);
            }
          } catch (err) {
            console.error(err.message);
            $(this).focus();
            return;
          }
        }

        that.dataModel.value = val;
        that.valueOnChange();
        that.exeEventHandler("onChange", val);
      });
    }
  }]);

  return Text;
}(_controller.FormInput);

exports["default"] = Text;