"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * 时间组件
 * @param {[type]} dataModel [description]
 */
var Time = /*#__PURE__*/function (_FormInput) {
  _inherits(Time, _FormInput);

  var _super = _createSuper(Time);

  function Time(__tfp, dataModel, parent) {
    var _this;

    _classCallCheck(this, Time);

    _this = _super.call(this, __tfp, "Time", dataModel, parent);

    _defineProperty(_assertThisInitialized(_this), "resetWidth", function () {
      var iptWidth = this.dataModel.showSecond ? 62 : 42;
      var cptMinWidth = iptWidth;
      if (this.showIcon) cptMinWidth += 30;
      var cptWidth = cptMinWidth;

      if (this._jqObj) {
        this._jqObj.css("width", cptWidth + "px");

        this._jqObj.css("min-width", cptMinWidth + "px");

        this._jqObj.find("input").css("width", iptWidth + "px");
      }

      if (!this.dataModel.styles) this.dataModel.styles = {};
      this.dataModel.styles["width"] = cptWidth + "px";
      this.dataModel.styles["min-width"] = cptMinWidth + "px";
    });

    return _this;
  } //属性


  _createClass(Time, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj) {
        this._jqObj.find("input").val(value);
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
  }, {
    key: "iconUrl",
    get: function get() {
      return this._tfp.rootPath + "/src/components/time/images/icon-24-" + this._tfp.curPage.contentColorMode + ".png";
    },
    set: function set(value) {}
  }, {
    key: "showIcon",
    get: function get() {
      return this.dataModel.showIcon;
    },
    set: function set(value) {
      this.dataModel.showIcon = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.showIcon) {
          if (this._jqObj.find("img").length == 0) {
            this._jqObj.append("<img src=\"" + this.iconUrl + "\" />");
          }
        } else {
          this._jqObj.find("img").remove();
        }

        this.resetWidth();
      }
    }
  }, {
    key: "showSecond",
    get: function get() {
      return this.dataModel.showSecond;
    },
    set: function set(value) {
      this.dataModel.showSecond = value ? true : false;

      if (this._jqObj) {
        this.resetWidth();

        if (this.dataModel.defaultNow && this._tfp.isDesigning) {
          this._jqObj.find("input").val(this.getCurTime());
        }
      }
    }
  }, {
    key: "defaultNow",
    get: function get() {
      return this.dataModel.defaultNow;
    },
    set: function set(value) {
      this.dataModel.defaultNow = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.defaultNow && this._tfp.isDesigning) {
          this._jqObj.find("input").val(this.getCurTime());
        } else {
          this._jqObj.find("input").val("");
        }
      }
    }
  }, {
    key: "clear",
    value: function clear() {
      this.value = "";
      this.closePicker();
    }
  }, {
    key: "closePicker",
    value: function closePicker() {
      $(".tfp-time-picker").remove();
      $("body").unbind("click", this.closePicker);
    }
  }, {
    key: "showPicker",
    value: function showPicker() {
      var offset = this._jqObj.offset();

      var html = "<div class=\"tfp-time-picker\" data-cptid=\"" + this.id + "\" " + "style=\"width: " + (this.showSecond ? 152 : 102) + "px; top: " + (offset.top + 31) + "px; left:" + offset.left + "px; display:none;\">";
      var vals = [];

      if (this.dataModel.value) {
        vals = this.dataModel.value.split(":");
      } else {
        vals = this.getCurTime().split(":");
      }

      html += "<ul data-value=\"" + vals[0] + "\">";

      for (var i = 0; i < 24; i++) {
        var hour = i < 10 ? "0" + i : i + "";
        html += "<li";
        if (hour == vals[0]) html += " style=\"background-color: #3399FF;color: #FFFFFF;\"";
        html += ">" + hour + "</li>";
      }

      html += "</ul>";
      html += "<ul data-value=\"" + vals[1] + "\">";

      for (var i = 0; i < 60; i++) {
        var minute = i < 10 ? "0" + i : i + "";
        html += "<li";
        if (minute == vals[1]) html += " style=\"background-color: #3399FF;color: #FFFFFF;\"";
        html += ">" + minute + "</li>";
      }

      html += "</ul>";

      if (this.showSecond) {
        html += "<ul data-value=\"" + vals[2] + "\">";

        for (var i = 0; i < 60; i++) {
          var second = i < 10 ? "0" + i : i + "";
          html += "<li";
          if (second == vals[2]) html += " style=\"background-color: #3399FF;color: #FFFFFF;\"";
          html += ">" + second + "</li>";
        }

        html += "</ul>";
      }

      html += "<div class=\"tfp-time-picker-footer\"><span>清空</span>" + "<input type=\"button\" value=\"确定\" /></div>";
      html += "</div>";
      $("body").append(html);
      var timePicker = $(".tfp-time-picker");
      timePicker.fadeIn("slow");
      timePicker.bind("click", function () {
        event.stopPropagation();
      });
      timePicker.find("ul").each(function () {
        $(this).find("li").each(function () {
          $(this).click(function () {
            $(this).parent().find("li").css("background-color", "");
            $(this).parent().find("li").css("color", "");
            $(this).css("background-color", "#3399FF");
            $(this).css("color", "#FFFFFF");
            $(this).parent().attr("data-value", $(this).html());
          });
        });
        $(this).get(0).scrollTop = parseInt($(this).attr("data-value") * 25);
      });
      var that = this;
      var footer = timePicker.find(".tfp-time-picker-footer");
      footer.find("span").click(function () {
        that.clear();
      });
      footer.find("input").click(function () {
        that.onCheckTime();
      });
      $("body").bind("click", this.closePicker);
    }
  }, {
    key: "onCheckTime",
    value: function onCheckTime() {
      var timePicker = $(".tfp-time-picker");
      var val = timePicker.find("ul").eq(0).attr("data-value");
      val += ":" + timePicker.find("ul").eq(1).attr("data-value");
      if (this.showSecond) val += ":" + timePicker.find("ul").eq(2).attr("data-value");
      this.value = val;
      this.closePicker();
    }
  }, {
    key: "getCurTime",
    value: function getCurTime() {
      return new Date().format(this.showSecond ? "HH:mm:ss" : "HH:mm");
    }
  }, {
    key: "render",
    value: function render() {
      _get(_getPrototypeOf(Time.prototype), "render", this).call(this);

      if (!this.dataModel.styles || !this.dataModel.styles.width) this.resetWidth();
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.click(function () {
        if (that.dataModel.readonly || that.dataModel.disabled) return;

        if ($(".tfp-time-picker").length > 0) {
          var cptId = $(".tfp-time-picker").attr("data-cptid");
          if (cptId == that.dataModel.id) return;
          that.closePicker();
        }

        that.showPicker();
        event.stopPropagation();
      });

      if (this.dataModel.defaultNow && !this.dataModel.value) {
        this.dataModel.value = this.getCurTime();

        this._jqObj.find("input").val(this.dataModel.value);
      }
    }
  }]);

  return Time;
}(_controller.FormInput);

exports["default"] = Time;