"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _controller = require("../controller.js");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * 时间组件
 * @param {[type]} dataModel [description]
 */
var Time = /*#__PURE__*/function (_FormInput) {
  _inherits(Time, _FormInput);

  var _super = _createSuper(Time);

  function Time(__tfp, dataModel, parent) {
    var _this;

    _classCallCheck(this, Time);

    _this = _super.call(this, __tfp, "Time", dataModel, parent);

    _defineProperty(_assertThisInitialized(_this), "resetWidth", function () {
      var iptWidth = this.dataModel.showSecond ? 62 : 42;
      var cptMinWidth = iptWidth;
      if (this.showIcon) cptMinWidth += 30;
      var cptWidth = cptMinWidth;

      if (this._jqObj) {
        this._jqObj.css("width", cptWidth + "px");

        this._jqObj.css("min-width", cptMinWidth + "px");

        this._jqObj.find("input").css("width", iptWidth + "px");
      }

      if (!this.dataModel.styles) this.dataModel.styles = {};
      this.dataModel.styles["width"] = cptWidth + "px";
      this.dataModel.styles["min-width"] = cptMinWidth + "px";
    });

    return _this;
  } //属性


  _createClass(Time, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj) {
        this._jqObj.find("input").val(value);
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
  }, {
    key: "iconUrl",
    get: function get() {
      return this._tfp.rootPath + "/src/components/time/images/icon-24-" + this._tfp.curPage.contentColorMode + ".png";
    },
    set: function set(value) {}
  }, {
    key: "showIcon",
    get: function get() {
      return this.dataModel.showIcon;
    },
    set: function set(value) {
      this.dataModel.showIcon = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.showIcon) {
          if (this._jqObj.find("img").length == 0) {
            this._jqObj.append("<img src=\"" + this.iconUrl + "\" />");
          }
        } else {
          this._jqObj.find("img").remove();
        }

        this.resetWidth();
      }
    }
  }, {
    key: "showSecond",
    get: function get() {
      return this.dataModel.showSecond;
    },
    set: function set(value) {
      this.dataModel.showSecond = value ? true : false;

      if (this._jqObj) {
        this.resetWidth();

        if (this.dataModel.defaultNow && this._tfp.isDesigning) {
          this._jqObj.find("input").val(this.getCurTime());
        }
      }
    }
  }, {
    key: "defaultNow",
    get: function get() {
      return this.dataModel.defaultNow;
    },
    set: function set(value) {
      this.dataModel.defaultNow = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.defaultNow && this._tfp.isDesigning) {
          this._jqObj.find("input").val(this.getCurTime());
        } else {
          this._jqObj.find("input").val("");
        }
      }
    }
  }, {
    key: "clear",
    value: function clear() {
      this.value = "";
      this.closePicker();
    }
  }, {
    key: "render",
    value: function render() {
      _get(_getPrototypeOf(Time.prototype), "render", this).call(this);

      if (!this.dataModel.styles || !this.dataModel.styles.width) this.resetWidth();
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.click(function () {
        var arrVal = [];
        if (that.dataModel.value) arrVal = that.dataModel.value.split(":");
        var optionsList = [];
        var curHour = new Date().getHours();
        curHour = curHour < 10 ? "0" + curHour : curHour + "";
        var hourOptions = {
          options: [],
          width: "80px",
          value: curHour
        };
        if (arrVal.length > 0) hourOptions.value = arrVal[0];

        for (var i = 0; i <= 23; i++) {
          var hour = i < 10 ? "0" + i : i + "";
          hourOptions.options.push(hour);
        }

        optionsList.push(hourOptions);
        var curMinute = new Date().getMinutes();
        curMinute = curMinute < 10 ? "0" + curMinute : curMinute + "";
        var minuteOptions = {
          options: [],
          width: "80px",
          value: curMinute
        };
        if (arrVal.length > 1) minuteOptions.value = arrVal[1];

        for (var i = 0; i <= 59; i++) {
          var day = i < 10 ? "0" + i : i + "";
          minuteOptions.options.push(day);
        }

        optionsList.push(minuteOptions);

        if (that.showSecond) {
          var curSecond = new Date().getSeconds();
          curSecond = curSecond < 10 ? "0" + curSecond : curSecond + "";
          var secondOptions = {
            options: [],
            width: "60px",
            value: curSecond
          };
          if (arrVal.length > 2) secondOptions.value = arrVal[2];

          for (var i = 0; i <= 59; i++) {
            var _day = i < 10 ? "0" + i : i + "";

            secondOptions.options.push(_day);
          }

          optionsList.push(secondOptions);
        }

        window.popupList.show(optionsList, function (vals) {
          var val = vals[0] + ":" + vals[1];
          if (that.showSecond) val += ":" + vals[2];
          that.value = val;
        });
      });
    }
  }]);

  return Time;
}(_controller.FormInput);

exports["default"] = Time;