export default {
  "name": "Button",
  "comment": "按钮",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [
    {
      "name": "buttonInfo",
      "comment": "按钮信息",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "按钮文本",
          "type": "String",
          "default": "{id}"
        },
        {
          "name": "labelHeight",
          "comment": "文本高度",
          "type": "Int",
          "default": "30"
        },
        {
          "name": "buttonType",
          "comment": "按钮类型",
          "type": "Select",
          "options": [
            {
              "value": "default",
              "text": "默认按钮"
            },
            {
              "value": "primary",
              "text": "主要按钮"
            },
            {
              "value": "info",
              "text": "信息按钮"
            },
            {
              "value": "warning",
              "text": "警告按钮"
            },
            {
              "value": "success",
              "text": "成功按钮"
            },
            {
              "value": "danger",
              "text": "危险按钮"
            }
          ]
        },
        {
          "name": "theme",
          "comment": "按钮风格",
          "type": "Select",
          "options": [
            {
              "value": "rect",
              "text": "默认"
            },
            {
              "value": "round",
              "text": "圆角矩形"
            },
            {
              "value": "circle",
              "text": "椭圆形"
            }
          ]
        },
        {
          "name": "plain",
          "comment": "浅色背景",
          "type": "Switch"
        },
        {
          "name": "title",
          "comment": "组件提示",
          "type": "String",
          "isHtmlAttr": true
        }
      ]
    },
    {
      "name": "imageSetting",
      "comment": "图片设置",
      "type": "group",
      "items": [
        {
          "name": "showImage",
          "comment": "显示图片",
          "type": "Switch"
        }, 
        {
          "name": "imageUrl",
          "comment": "图片地址",
          "type": "String",
          "hidden": "'{showImage}'!='true'"
        }, 
        {
          "name": "imageWidth",
          "comment": "图片宽度",
          "type": "Int",
          "default": 24,
          "hidden": "'{showImage}'!='true'"
        }, 
        {
          "name": "imageHeight",
          "comment": "图片高度",
          "type": "Int",
          "default": 24,
          "hidden": "'{showImage}'!='true'"
        }, 
        {
          "name": "portrait",
          "comment": "竖向显示",
          "type": "Switch",
          "hidden": "'{showImage}'!='true' || '{hiddenText}'=='true'"
        },
        {
          "name": "hiddenText",
          "comment": "隐藏文字",
          "type": "Switch",
          "hidden": "'{showImage}'!='true'"
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "background", "margin", "border", "other"],
  "defaultStyles": {
    "cursor": "pointer",
    "padding-left": "10px",
    "padding-right": "10px",
    "text-align": "center"
  },
  "events": [{
    "name": "onClick", 
    "comment": "点击时"
  }, {
    "name": "onFocus",
    "comment": "获得焦点时"
  }, {
    "name": "onBlur",
    "comment": "失去焦点时"
  }, {
    "name": "onChange",
    "comment": "值发生变化时"
  }]
}