import TFPComponentRender from '../render.js'

export default class ButtonRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getSpecialClass() {
    let classHtml = " tfp-button-" + (this.dataModel.buttonType ? this.dataModel.buttonType : "default");
    if(this.dataModel.plain) classHtml += "-plain";
    classHtml += " tfp-button-" + (this.dataModel.theme ? this.dataModel.theme : "rect");
    return classHtml;
  }

  getAttrHtml() {
    var attrHtml = super.getAttrHtml();
    if(this._tfp.isDesigning && attrHtml.indexOf("readonly")<0) 
      attrHtml += " readonly";
    return attrHtml;
  }

  getBodyHtml(getComponentsHtml) {
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    if(this.dataModel.showImage) {
      let imgUrl = this.dataModel.imageUrl;
      if(!imgUrl) {
        imgUrl = this._tfp.rootPath+"/src/components/button/images/default-photo.png";
      } else if(this._tfp.isDesigning) {
        imgUrl = this._tfp.getUrlRealPath(imgUrl);
      }
      let imgWidth = 24;
      if(this.dataModel.imageWidth) imgWidth = parseInt(this.dataModel.imageWidth);
      let imgHeight = 24;
      if(this.dataModel.imageHeight) imgHeight = parseInt(this.dataModel.imageHeight);
      let imgMargin = 3;
      if(this.dataModel.portrait && !this.dataModel.hiddenText) imgMargin = 10;
      let imgHtml = indent+"\t<img src=\""+imgUrl+"\" width=\""+imgWidth+"\" height=\""
        +imgHeight+"\" style=\"margin-top:"+imgMargin+"px; margin-bottom:3px;\" />\r\n";
      let lineHeight = 30;
      if(!this.dataModel.portrait) lineHeight = imgHeight + imgMargin + 3;
      if(this.dataModel.hiddenText) {
        bodyHtml += indent+"\t<div style=\"width:100%;\">\r\n\t"+imgHtml+indent+"\t</div>\r\n";
        bodyHtml += indent+"\t<label style=\"display:none;line-height:30px;\">"+this.dataModel.value+"</label>\r\n";
      } else {
        if(this.dataModel.portrait) {
          bodyHtml += indent+"\t<div style=\"width:100%;\">\r\n\t"+imgHtml+indent+"\t</div>\r\n";
          bodyHtml += indent+"\t<label style=\"line-height:"+this._tfp.formatPx(this.cpt.labelHeight)
            +";\">"+this.dataModel.value+"</label>\r\n";
        } else {
          bodyHtml += indent+"\t<div style=\"float:left;display:block;\">\r\n\t"+imgHtml+indent+"\t</div>\r\n";
          bodyHtml += indent+"\t<label style=\"margin-left:7px;line-height:"+lineHeight+"px;\">"+this.dataModel.value+"</label>\r\n";
        }
      }
    } else {
      if(this.dataModel.value) {
        bodyHtml += indent+"\t<label style=\"line-height:"+this._tfp.formatPx(this.cpt.labelHeight)
          +";\">"+this.dataModel.value+"</label>\r\n";
      }
    }
    return bodyHtml+indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}