import {VisibleComponent} from "./controller.js";

/**
 * 图表组件
 * @param {[type]} dataModel [description]
 */
export default class Chart extends VisibleComponent {

  constructor(__tfp, inputType, dataModel, parent) {
    super(__tfp, inputType, dataModel, parent);
  }

  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) { this.dataModel.loadDataService = value }

  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) { this.dataModel.dataBindingMember = value }

  get showLegend() { return this.dataModel.showLegend }
  set showLegend(value) { 
    this.dataModel.showLegend = value ? true : false;
  }

  get showLabel() { return this.dataModel.showLabel }
  set showLabel(value) { 
    this.dataModel.showLabel = value ? true : false;
  }

  get showLabelLine() { return this.dataModel.showLabelLine }
  set showLabelLine(value) { 
    this.dataModel.showLabelLine = value ? true : false;
  }

  get showLoading() { return this.dataModel.showLoading }
  set showLoading(value) { 
    this.dataModel.showLoading = value ? true : false;
  }

  get animation() { return this.dataModel.animation }
  set animation(value) { 
    this.dataModel.animation = value ? true : false;
  }

  getDemoData() {
    var data = {
      seriesData: []
    };
    if(this.type!="ChartPie" && this.type!="ChartAnnular") {
      var dataSet = this.dataModel.series;
      if(!dataSet || dataSet.length==0) {
        if(this.type=="ChartLine") {
          data.series = [{
            name: "演示数据",
            type: "line"
          }];
        } else if(this.type=="ChartBar") {
          data.series = [{
            name: "演示数据",
            type: "bar"
          }];
        } else if(this.type=="ChartBarY") {
          data.series = [{
            name: "演示数据",
            type: "bar"
          }];
        } else if(this.type=="ChartLineBar") {
          data.series = [{
            name: "演示数据1",
            type: "line"
          },{
            name: "演示数据2",
            type: "bar"
          }];
        }
        dataSet = data.series;
      }
      data.categoryData = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
      for(var i=0;i<dataSet.length;i++) {
        var itemData = [];
        for(var j=0;j<7;j++) {
          itemData.push(Math.ceil(Math.random()*1000));
        }
        data.seriesData.push(itemData);
      }
    } else {
      data.seriesData = [
          {value: 1048, name: '搜索引擎'},
          {value: 735, name: '直接访问'},
          {value: 580, name: '邮件营销'},
          {value: 484, name: '联盟广告'},
          {value: 300, name: '视频广告'}
      ];
    }
    return data;
  }

  bindData(data) {
    if(!this.chart) this.chart = echarts.init(document.getElementById(this.id));
    var option = {
      series: []
    };
    //if(this.dataModel.darkMode) option.darkMode = true;
    if(this.type!="ChartPie" && this.type!="ChartAnnular") {
      if(this.dataModel.showLegend) {
        option.legend = {
          data: []
        };
      } else {
        delete option["legend"];
      }
      option.grid = {
        left: "40px",
        right: "20px"
      };
      if(this.type=="ChartBarY") {
        option.yAxis = {
          type: 'category'
        };
        if(this._tfp.isDesigning) {
          option.yAxis.data = data.categoryData;
        } else {
          option.yAxis.data = [];
        }
        option.xAxis = {
          type: 'value'
        };
      } else {
        option.xAxis = {
          type: 'category'
        };
        if(this._tfp.isDesigning) {
          option.xAxis.data = data.data;
        } else {
          option.xAxis.data = [];
        }
        option.yAxis = {
          type: 'value'
        };
      }
      var dataSet = this.dataModel.series;
      if(!dataSet || dataSet.length==0) dataSet = data.series;
      for(var i=0;i<dataSet.length;i++) {
        var s = dataSet[i];
        if(this.dataModel.showLegend) option.legend.data.push(s.name);
        var item = {
          name: s.name
        };
        if(this.type=="ChartLine") {
          item.type = "line";
        } else if(this.type=="ChartBar" || this.type=="ChartBarY") {
          item.type = "bar";
        } else {
          item.type = s.type;
        }
        if(this.dataModel.stack) {
          item.stack = "total";
        } else {
          delete item["stack"];
        }
        if(this.dataModel.smooth) {
          item.smooth = true;
        } else {
          item.smooth = false;
        }
        if(this.dataModel.showArea) {
          item.areaStyle = {};
        } else {
          delete item["areaStyle"];
        }
        item.label = {
          show: true
        };
        if(!this.dataModel.showLabel) item.label.show = false;
        item.labelLine = {
          show: true
        };
        if(!this.dataModel.showLabelLine) item.labelLine.show = false;
        if(this._tfp.isDesigning) {
          item.data = data.seriesData[i];
        } else {
          item.data = [];
        }
        option.series.push(item);
      }

      if(!this._tfp.isDesigning && this.dataModel.categoryField) {
        for(var i=0;i<data.length;i++) {
          var rowData = data[i];
          if(this.type=="ChartBarY") {
            option.yAxis.data.push(rowData[this.dataModel.categoryField]);
          } else {
            option.xAxis.data.push(rowData[this.dataModel.categoryField]);
          }
          for(var j=0;j<dataSet.length;j++) {
            var s = dataSet[j];
            var item = option.series[j];
            item.data.push(rowData[s.dataField]);
          }
        }
      }
    } else {
      var s = {
        type: "pie",
        data: []
      };
      if(this.type=="ChartPie") {
        if(this.dataModel.radius) {
          s.radius = this.dataModel.radius;
        } else {
          s.radius = "50%";
        }
      } else {
        var outerRadius = this.dataModel.outerRadius;
        if(!outerRadius) outerRadius = "40%";
        var innerRadius = this.dataModel.innerRadius;
        if(!innerRadius) innerRadius = "70%";
        s.radius = [outerRadius, innerRadius];
      }
      if(this._tfp.isDesigning) {
        s.data = data.seriesData;
      } else if(data && data.length>0 && this.dataModel.nameField && this.dataModel.valueField) {
        for(var i=0;i<data.length;i++) {
          let rowData = data[i];
          let itemData = {
            name: rowData[this.dataModel.nameField],
            value: rowData[this.dataModel.valueField]
          };
          if(!itemData.name || (!itemData.value && itemData.value!=0)) continue;
          s.data.push(itemData);
        }
      }
      option.series.push(s);
    }
    if(this.dataModel.showLoading) this.chart.showLoading();
    this.chart.setOption(option);
    if(this.dataModel.showLoading) this.chart.hideLoading();
  }

  loadData(args) {
    if(!this.dataModel.loadDataService) {
      alert("请为["+this.id+"]设置加载数据服务！");
      return;
    }
    let serviceCpt = this._tfp.get(this.dataModel.loadDataService);
    if(!serviceCpt) {
      alert("ID为["+this.dataModel.loadDataService+"]的组件不存在！");
      return;
    }
    if(!this.dataModel.dataBindingMember) {
      alert("请为["+this.id+"]设置数据绑定成员！");
      return;
    }

    let that = this;
    serviceCpt.request(args, function(req, res) {
      if(res.code!=0) {
        tfp.showMsg(res.message);
        return;
      }
      if(that.dataModel.dataBindingMember) {
        that.bindData(res[that.dataModel.dataBindingMember]);
      } else {
        that.bindData(res);
      }
    });
  };

  render() {
    super.render();

    if(this._tfp.isDesigning) {
      var data = this.getDemoData();
      this.bindData(data);
    }
  }

  initRuntime() {
    if(!this.dataModel.loadDataService) return;
    this.loadData();
  }
}