export default {
  "name": "ChartAnnular",
  "comment": "环形图",
  "jsFiles": "/node_modules/echarts/dist/echarts.common.min.js",
  "attrs": [
    {
      "name": "dataBindSetting",
      "comment": "数据绑定设置",
      "type": "group",
      "items": [
        {
          "name": "loadDataService",
          "comment": "加载数据服务",
          "type": "Service"
        },
        {
          "name": "dataBindingMember",
          "comment": "数据绑定成员",
          "type": "String"
        },
        {
          "name": "nameField",
          "comment": "数据分类字段",
          "type": "String"
        },
        {
          "name": "valueField",
          "comment": "数据值字段",
          "type": "String"
        }
      ]
    },
    {
      "name": "showSetting",
      "comment": "显示设置",
      "type": "group",
      "items": [
        {
          "name": "showLegend",
          "comment": "显示图例",
          "type": "Switch"
        },
        {
          "name": "showLoading",
          "comment": "显示加载动画",
          "type": "Switch"
        },
        {
          "name": "showLabel",
          "comment": "显示标签",
          "type": "Switch",
          "default": true,
          "width": "60px"
        },
        {
          "name": "showLabelLine",
          "comment": "显示引导线",
          "type": "Switch",
          "width": "80px"
        },
        {
          "name": "animation",
          "comment": "开启动画",
          "type": "Switch",
          "default": true
        },
        {
          "name": "outerRadius",
          "comment": "外半径",
          "type": "String",
          "width": "60px"
        },
        {
          "name": "innerRadius",
          "comment": "内半径",
          "type": "String",
          "width": "60px"
        }
      ]
    }
  ],
  "styles": ["size", "position", "background", "margin", "border", "other"],
  "defaultStyles": {
    "width": "480px",
    "height": "320px",
    "border": "1px solid #cccccc"
  },
  "events": []
}