import {FormInput} from "../controller.js";

/**
 * 日期时间组件
 * @param {[type]} dataModel [description]
 */
export default class DateTime extends FormInput {

  constructor(__tfp, dataModel, parent, inputType) {
    if(inputType) {
      super(__tfp, inputType, dataModel, parent);
    } else {
      super(__tfp, "DateTime", dataModel, parent);
    }
  }

  //属性
  get value() { return this.dataModel.value }
  set value(value) {
    if(value!=null && value!=undefined) {
      if(value instanceof Date) {
        if(this.dataModel.type=="Date") {
          this.dataModel.value = value.format("yyyy-MM-dd");
        } else {
          if(this.dataModel.showSecond) {
            this.dataModel.value = value.format("yyyy-MM-dd hh:mm");
          } else {
            this.dataModel.value = value.format("yyyy-MM-dd hh:mm:ss");
          }
        }
      } else if(typeof(value)=="string") {
        this.dataModel.value = value;
      } else {
        //不支持
      }
    } else {
      this.dataModel.value = null;
    }
    if(this._jqObj) {
      if(this.dataModel.value) {
        this._jqObj.find("input").val(this.dataModel.value);
      } else {
        this._jqObj.find("input").val("");
      }
    }
    if(!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  get iconUrl() {
    return this._tfp.rootPath+"/src/components/"+this.type.toLowerCase()
      +"/images/icon-24-"+this._tfp.curPage.contentColorMode+".png";
  }
  set iconUrl(value) {}

  get showIcon() { return this.dataModel.showIcon }
  set showIcon(value) { 
    this.dataModel.showIcon = value ? true : false;
    if(this._jqObj) {
      if(this.dataModel.showIcon) {
        if(this._jqObj.find("img").length==0) {
          this._jqObj.append("<img src=\""+this.iconUrl+"\" />");
        }
      } else {
        this._jqObj.find("img").remove();
      }
      this.resetWidth();
    }
  }

  get showSecond() { return this.dataModel.showSecond }
  set showSecond(value) { 
    this.dataModel.showSecond = value ? true : false;
    if(this._jqObj) {
      this.resetWidth();
      if(this.dataModel.defaultNow && this._tfp.isDesigning) {
        this._jqObj.find("input").val(this.getCurDateTime());
      }
    }
  }

  get defaultNow() { return this.dataModel.defaultNow }
  set defaultNow(value) { 
    this.dataModel.defaultNow = value ? true : false;
    if(this._jqObj) {
      if(this.dataModel.defaultNow && this._tfp.isDesigning) {
        this._jqObj.find("input").val(this.getCurDateTime());
      } else {
        this._jqObj.find("input").val("");
      }
    }
  }

  get startYear() { 
    if(this.dataModel.startYear) return this.dataModel.startYear; 
    return (new Date()).getFullYear()-50; 
  }
  set startYear(value) { 
    this.dataModel.startYear = parseInt(value);
  }

  get endYear() { 
    if(this.dataModel.endYear) return this.dataModel.endYear; 
    return (new Date()).getFullYear()+50; 
  }
  set endYear(value) { 
    this.dataModel.endYear = parseInt(value);
  }

  getIptWidth() {
    let iptWidth = 90;
    if(this.dataModel.type=="DateTime") {
      iptWidth = 130;
      if(this.dataModel.showSecond) iptWidth = 150;
    }
    return iptWidth;
  }

  resetWidth() {
    let iptWidth = this.getIptWidth();
    let cptWidth = iptWidth;
    if(this.showIcon) cptWidth += 30;
    this._jqObj.find("input").css("width", iptWidth+"px");
    this._jqObj.css("width", cptWidth+"px");
    this._jqObj.css("min-width", cptWidth+"px");
    if(!this.dataModel.styles) this.dataModel.styles = {};
    this.dataModel.styles["width"] = cptWidth+"px";
    this.dataModel.styles["min-width"] = cptWidth+"px";
  }

  clear() {
    this.value = "";
    this.closePicker();
  }

  getCurDateTime() {
    if(this.type=="Date") return (new Date()).format("yyyy-MM-dd");
    if(this.type=="DateTime") {
      if(this.showSecond) {
        return (new Date()).format("yyyy-MM-dd HH:mm:ss");
      } else {
        return (new Date()).format("yyyy-MM-dd HH:mm");
      }
    }
  }

  getDateOptions(optionsList) {
    let dateVal = new Date();
    if(this.dataModel.value) dateVal = new Date(this.dataModel.value);

    let yearOptions = {
      options: [],
      width: "80px",
      value: dateVal.getFullYear()+""
    };
    for(var i=this.startYear;i<=this.endYear;i++) {
      yearOptions.options.push(i+"");
    }

    let curMonth = dateVal.getMonth()+1;
    curMonth = curMonth<10 ? "0"+curMonth : curMonth+"";
    let monthOptions = {
      options: [],
      width: this.dataModel.type=="DateTime" ? "60px" : "80px",
      value: curMonth
    };
    for(var i=1;i<=12;i++) {
      let month = i<10 ? "0"+i : i+"";
      monthOptions.options.push(month);
    }
    monthOptions.onChange = function() {
      let month = window.popupList.getColumnVal(1);
      let dayCol = $(".tfp-popuplist-content-column").get(2);
      let items = $(dayCol).find(".tfp-popuplist-content-item");
      if(month=="02") {
        items.eq(32).hide();
        items.eq(33).hide();
        let year = parseInt(window.popupList.getColumnVal(0));
        if(year % 4 == 0) {
          items.eq(31).show();
        } else {
          items.eq(31).hide();
        }
      } else if(["04","06","09","11"].contains(month)) {
        items.eq(31).show();
        items.eq(32).show();
        items.eq(33).hide();
      } else {
        items.eq(31).show();
        items.eq(32).show();
        items.eq(33).show();
      }
    };

    let curDay = dateVal.getDate();
    curDay = curDay<10 ? "0"+curDay : curDay+"";
    let dateOptions = {
      options: [],
      width: this.dataModel.type=="DateTime" ? "60px" : "80px",
      value: curDay
    };
    for(var i=1;i<=31;i++) {
      let day = i<10 ? "0"+i : i+"";
      dateOptions.options.push(day);
    }
    optionsList.push(yearOptions);
    optionsList.push(monthOptions)
    optionsList.push(dateOptions);
  }

  getTimeOptions(optionsList) {
    let dateVal = new Date();
    if(this.dataModel.value) dateVal = new Date(this.dataModel.value);

    let curHour = dateVal.getHours();
    curHour = curHour<10 ? "0"+curHour : curHour+"";
    let hourOptions = {
      options: [],
      width: "60px",
      value: curHour
    };
    for(var i=0;i<=23;i++) {
      let hour = i<10 ? "0"+i : i+"";
      hourOptions.options.push(hour);
    }
    optionsList.push(hourOptions);
    
    let curMinute = dateVal.getMinutes();
    curMinute = curMinute<10 ? "0"+curMinute : curMinute+"";
    let minuteOptions = {
      options: [],
      width: "60px",
      value: curMinute
    };
    for(var i=0;i<=59;i++) {
      let day = i<10 ? "0"+i : i+"";
      minuteOptions.options.push(day);
    }
    optionsList.push(minuteOptions);

    if(this.showSecond) {
      let curSecond = dateVal.getSeconds();
      curSecond = curSecond<10 ? "0"+curSecond : curSecond+"";
      let secondOptions = {
        options: [],
        width: "60px",
        value: curSecond
      };
      for(var i=0;i<=59;i++) {
        let day = i<10 ? "0"+i : i+"";
        secondOptions.options.push(day);
      }
      optionsList.push(secondOptions);
    }
  }

  initRuntime() {
    let that = this;
    this._jqObj.click(function() {
      let optionsList = [];
      that.getDateOptions(optionsList);
      if(that.dataModel.type=="DateTime") {
        that.getTimeOptions(optionsList);
      }
      window.popupList.show(optionsList, function(vals) {
        console.log(vals);
        let val = vals[0]+"-"+vals[1]+"-"+vals[2];
        if(that.dataModel.type=="DateTime") {
          val += " "+vals[3]+":"+vals[4];
          if(that.showSecond) val += ":"+vals[5];
        }
        that.value = val;
      });
    });
  }
}