import {VisibleComponent} from "../controller.js";

/**
 * Excel导出组件
 * @param {[type]} dataModel [description]
 */
export default class ExcelExport extends VisibleComponent {

  constructor(__tfp, dataModel, parent, inputType) {
    if(inputType) {
      super(__tfp, inputType, dataModel, parent);
    } else {
      super(__tfp, "ExcelExport", dataModel, parent);
    }
  }

  //属性
  get text() { return this.dataModel.text }
  set text(value) { 
    this.dataModel.text = value;
    if(this._jqObj) {
      this._jqObj.html(value);
    }
  }

  get theme() { return this.dataModel.theme }
  set theme(value) { 
    let theme = "rect";
    if(value) theme = value;
    if(!this.checkAttrOption("theme", theme)) {
      this._tfp.showMsg("不支持风格："+theme+"！");
      return;
    }
    this.dataModel.theme = theme;
    if(this._jqObj) {
      this._jqObj.removeClass("tfp-button-round tfp-button-rect tfp-button-circle");
      this._jqObj.addClass("tfp-button-"+theme);
    }
  }

  get service() { return this.dataModel.service }
  set service(value) { this.dataModel.service = value }

  initRuntime() {
    var that = this;
    this._jqObj.click(function() {
      if(!that.dataModel.service) {
        that._tfp.showMsg("请设置导出数据的后台服务！");
        return;
      }
      let serviceCpt = that._tfp.components[that.dataModel.service];
      serviceCpt.request(null, function(req, res) {
        if(res.code!=0) {
          that._tfp.showMsg(res.message);
          return;
        }
        $('.exportlink').remove();
        $('body').append('<a class="exportlink" style="display:none;" href="javascript:"></a>');
        $('.exportlink').click(function() {
          let url = "/Download?fileCode="+res.fileCode;
          window.location.href = that._tfp.setUrlAuthData(url);
        });
        $('.exportlink').click();
      });
    });
  }
}