export default {
  "name": "ExcelExport",
  "comment": "Excel导出",
  "cssFiles": [
    "../button/style.{bgColorMode}.css",
    "style.css"
  ],
  "attrs": [
    {
      "name": "text",
      "comment": "按钮文本",
      "type": "String",
      "default": "导出"
    },
    {
      "name": "theme",
      "comment": "按钮风格",
      "type": "Select",
      "special": true,
      "default": "rect",
      "options": [
        {
          "value": "rect",
          "text": "矩形"
        },
        {
          "value": "round",
          "text": "圆角矩形"
        },
        {
          "value": "circle",
          "text": "椭圆形"
        }
      ]
    },
    {
      "name": "service",
      "comment": "导出后台服务",
      "type": "Service"
    }
  ],
  "styles": ["size", "position", "font", "background", "margin", "border", "other"],
  "defaultStyles": {
    "background-color": "#0066ff",
    "border": "0",
    "color": "#ffffff"
  },
  "events": [{
    "name": "onExport",
    "comment": "完成导出后"
  }]
}