import ExcelExport from "../excelexport/controller.pc.js";

/**
 * Excel导入组件
 * @param {[type]} dataModel [description]
 */
export default class ExcelImport extends ExcelExport {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, dataModel, parent, "ExcelImport");
  }

  initRuntime() {
    var that = this;
    this._jqObj.click(function() {
      if(!that.dataModel.service) {
        that._tfp.showMsg("请设置导入服务路径！");
        return;
      }
      let url = that._tfp.rootPath+"/src/components/excelimport/tfp/importExcel.tfp?servicePath="+that.dataModel.service;
      if(that.dataModel.onImport) url += "&cb="+that._tfp.getCptEventFuncName(that.dataModel.onImport);
      that._tfp.openDialog("导入Excel数据", url, "480px", "320px", null, window);
    });
  }
}