export default {
  "name": "FileUpload",
  "comment": "文件上传",
  "cssFiles": ["style.css", "../button/style.{bgColorMode}.css"],
  "attrs": [
    {
      "name": "fileType",
      "comment": "文件类型",
      "type": "String"
    },
    {
      "name": "appCode",
      "comment": "应用代码",
      "type": "String"
    },
    {
      "name": "appDataId",
      "comment": "应用数据ID",
      "type": "String"
    },
    {
      "name": "size",
      "comment": "文件总数",
      "type": "Number",
      "default": 10
    },
    {
      "name": "allowUpload",
      "comment": "允许上传",
      "type": "Switch",
      "default": true
    },
    {
      "name": "allowDelete",
      "comment": "允许删除",
      "type": "Switch",
      "default": true
    }
  ],
  "styles": ["size", "position", "font", "background", "margin", "border", "other"],
  "defaultStyles": {
    "overflow": "auto"
  },
  "events": [{
    "name": "onClick", 
    "comment": "点击时"
  }, {
    "name": "onChange",
    "comment": "值发生变化时"
  }]
}