import TFPComponentRender from '../render.js'

export default class FileUploadRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    if(this._tfp.isDesigning) {
      html += indent+"\t<input type=\"button\" value=\"上传文件\" "
        +"class=\"tfp-button tfp-button-primary\" style=\"line-height:30px;\" />\r\n";
    } else {
      if(this.dataModel.allowUpload) {
        html += indent+"\t<div class=\"tfp-fileupload-row\" style=\"height:40px;\">"
          +"<input type=\"button\" value=\"上传文件\" "
          +"class=\"tfp-button tfp-button-primary\" style=\"line-height:30px;\" />"
          +"</div>\r\n";
      }
      if(this.cpt.files) {
        for(var i=0;i<this.cpt.files.length;i++) {
          let fileInfo = this.cpt.files[i];
          html += indent+"\t<div class=\"tfp-fileupload-row\">"
            +indent+"\t\t<p class=\"tfp-fileupload-fileinfo\">"
            +"<img src=\"/images/icon/16/attach.png\" align=\"absmiddle\" />&nbsp;&nbsp;"
            +"<a href=\"/Download?fileCode="+fileInfo.code+"\">"+fileInfo.name+"</a>"
            +indent+"\t\t</p>\r\n"
            +indent+"\t</div>\r\n";
        }
      }
    }
    return html+indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}