import {VisibleComponent} from "../controller.js";

/**
 * 弹性栅格组件
 * @param {[type]} dataModel [description]
 */
export default class FlexBox extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "FlexBox", dataModel, parent);

    if(this._tfp.isDesigning && 
      (!this.dataModel.components 
        || this.dataModel.components.length==0)) {
      if(this._tfp.curPage.client=="pc"
        || this._tfp.curPage.client=="tb") {
        this.dataModel.components = [{
          id: this.id+"_panel1",
          type: "Panel",
          styles: {
            "flex-grow": 0,
            "flex-shrink": 0,
            "flex-basis": "180px",
            "height": "30px",
            "line-height": "30px"
          }
        },{
          id: this.id+"_panel2",
          type: "Panel",
          styles: {
            "flex-grow": 1,
            "flex-shrink": 0,
            "flex-basis": "auto",
            "height": "30px",
            "line-height": "30px"
          }
        }];
      } else if(this._tfp.curPage.client=="phone") {
        this.dataModel.components = [{
          id: this.id+"_panel1",
          type: "Panel",
          styles: {
            "flex-grow": 0,
            "flex-shrink": 0,
            "flex-basis": "120px",
            "height": "30px",
            "line-height": "30px"
          }
        }, {
          id: this.id+"_panel2",
          type: "Panel",
          styles: {
            "flex-grow": 1,
            "flex-shrink": 0,
            "flex-basis": "auto",
            "height": "30px",
            "line-height": "30px"
          }
        }];
      }
    }
  }

  //不是容器组件，但可以添加子组件
  get containerEl() { return this.el }

  get items() { 
    var items = [];
    if(this.dataModel.components) {
      for(var i=0; i<this.dataModel.components.length;i++) {
        let itemDM = this.dataModel.components[i];
        items.push({
          id: itemDM.id, 
          "flex-grow": itemDM.styles["flex-grow"], 
          "flex-shrink": itemDM.styles["flex-shrink"], 
          "flex-basis": itemDM.styles["flex-basis"]
        });
      }
    }
    return items;
  }
  set items(value) {
    let items = [];
    if(value) items = value;
    let components = [];
    for(var i=0;i<items.length;i++) {
      let item = items[i];
      let cdm = null;
      if(item.id) {
        let panelChild = this._tfp.components[item.id];
        cdm = panelChild.dataModel;
        //delete this._tfp.components[panelChild.id];
      } else {
        let flexGrow = 1;
        if(!isNull(item["flex-grow"])) flexGrow = item["flex-grow"];
        let flexShrink = 0;
        if(!isNull(item["flex-shrink"])) flexShrink = item["flex-shrink"];
        let flexBasis = "auto";
        if(!isNull(item["flex-basis"])) flexBasis = item["flex-basis"];
        cdm = {
          type: "Panel",
          styles: {
            "flex-grow": flexGrow,
            "flex-shrink": flexShrink,
            "flex-basis": flexBasis,
            "height": "30px",
            "line-height": "30px"
          }
        };
        //if(i>0) cdm.styles["margin-left"] = "10px";
      }
      components.push(cdm);
    }
    this.clear();
    this.dataModel.components = components;
    this._jqObj.remove();
    this.isRendered = false;
    this.render();
  }

  get direction() { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "flex-direction": "row"
      };
    }
    return this.dataModel.styles["flex-direction"];
  }
  set direction(value) { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "flex-direction": "row"
      };
    }
    this.dataModel.styles["flex-direction"] = value;
    if(this._jqObj) this._jqObj.css("flex-direction", value);
  }

  get wrap() { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "flex-wrap": "nowrap"
      };
    }
    return this.dataModel.styles["flex-wrap"];
  }
  set wrap(value) { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "flex-wrap": "nowrap"
      };
    }
    this.dataModel.styles["flex-wrap"] = value ? "wrap" : "nowrap";
    if(this._jqObj) this._jqObj.css("flex-wrap", value);
  }

  get align() { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "justify-content": "flex-start"
      };
    }
    return this.dataModel.styles["justify-content"];
  }
  set align(value) { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "justify-content": "flex-start"
      };
    }
    this.dataModel.styles["justify-content"] = value;
    if(this._jqObj) this._jqObj.css("justify-content", value);
  }

  get valign() { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "align-items": "stretch"
      };
    }
    return this.dataModel.styles["align-items"];
  }
  set valign(value) { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "align-items": "stretch"
      };
    }
    this.dataModel.styles["align-items"] = value;
    if(this._jqObj) this._jqObj.css("align-items", value);
  }
}