import {ContainerComponent} from "../controller.js";

/**
 * 表单组件
 * @param {[type]} dataModel [description]
 */
export default class Form extends ContainerComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Form", dataModel, parent);
  }

  //loadDataService属性
  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) {this.dataModel.loadDataService = value}

  //dataBindingMember属性
  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) {this.dataModel.dataBindingMember = value}

  //submitService属性
  get submitService() { return this.dataModel.submitService }
  set submitService(value) {this.dataModel.submitService = value}

  //是否显示提交成功提示
  get showSubmitSuccessHint() { return this.dataModel.showSubmitSuccessHint ? true : false }
  set showSubmitSuccessHint(value) {this.dataModel.showSubmitSuccessHint = value ? true : false}

  /**
   * 校验表单输入项的数据是否符合要求
   * @param  {[type]} ipt  [description]
   * @param  {[type]} args [description]
   * @return {[type]}      [description]
   */
  checkInputData(cdm, args) {
    let cpt = this._tfp.get(cdm.id);
    let cptTypeInfo = this._tfp.type(cpt.type);
    if(cpt.isFormInput) {
      if(cpt.required && isNull(cpt.value)) {
        if(cpt.placeHolder) {
          this._tfp.showMsg(cpt.placeHolder);
        } else if(cpt.comment) {
          this._tfp.showMsg(cpt.comment+"不能为空！");
        } else {
          this._tfp.showMsg(cpt.id+"不能为空！");
        }
        if(cpt.focus) cpt.focus();
        return false;
      }

      if(!isNull(cpt.value)) {
        args[cpt.id] = cpt.value;
        /*if(ipt.type=="DateTime" && ipt.value.length<19) {
          args[ipt.id] = ipt.value + ":00";
        } else if(ipt.type=="Date" && ipt.value.length<19) {
          args[ipt.id] = ipt.value + " 0:00:00";
        }*/
      }
    } else if(cpt.type=="DataSet") {
      let rows = cpt.getRows({checkRequired: true});
      if(!rows) return false;
      args[cpt.id] = rows;
    }
    let isOK = true;
    if(cdm.components) {
      for(var i=0;i<cdm.components.length;i++) {
        isOK = this.checkInputData(cdm.components[i], args);
        if(!isOK) return false;
      }
    }
    return isOK;
  }

  submit() {
    if(!this.dataModel.submitService) {
      alert("请为["+this.id+"]设置数据提交服务！");
      return;
    }
    let serviceCpt = this._tfp.get(this.dataModel.submitService);
    if(!serviceCpt) {
      alert("ID为["+this.dataModel.submitService+"]的组件不存在！");
      return;
    }

    //对表单内的输入项的数据进行校验，并生成请求参数
    let args = {};
    let isOK = true;
    if(this.dataModel.components) {
      for(var i=0;i<this.dataModel.components.length;i++) {
        isOK = this.checkInputData(this.dataModel.components[i], args);
        if(!isOK) return;
      }
    }

    let that = this;
    serviceCpt.request(args, function(req, res) {
      if(that.dataModel.showSubmitSuccessHint) that._tfp.showMsg("提交成功！");
      /*if(that._tfp.curPage.pagetype=="dialog") {
        onDialogOK({req: req, res: res});
        closeCurDialog();
      }*/
    });
  }

  bindData(data) {
    if(!this.dataModel.components) return;
    for(var i=0;i<this.dataModel.components.length;i++) {
      this._tfp.bindCptData(this.dataModel.components[i], data);
    }
  }

  loadData() {
    if(!this.dataModel.loadDataService) {
      alert("请为["+this.id+"]设置加载数据服务！");
      return;
    }
    let serviceCpt = this._tfp.get(this.dataModel.loadDataService);
    if(!serviceCpt) {
      alert("ID为["+this.dataModel.loadDataService+"]的组件不存在！");
      return;
    }

    let that = this;
    //与服务组件建立绑定
    if(!serviceCpt.bindCpts) serviceCpt.bindCpts = [];
    if(!serviceCpt.bindCpts.contains(this.id)) serviceCpt.bindCpts.push(this.id);
    serviceCpt.request(null, function(req, res) {
      var data = res;
      //如果设置了数据绑定成员名称，则从服务响应对象中取这个成员对象作为表单的数据源
      //否则，将整个响应对象作为表单的数据源
      if(that.dataModel.dataBindingMember) data = res[that.dataModel.dataBindingMember];
      //把表单的数据先缓存起来，以便后续某些场景需要继续使用
      that.dataModel.data = data;
      that.bindData(data);
    });
  }

  initRuntime() {
    if(!this.dataModel.loadDataService) return;
    this.loadData();
  }
}