export default {
  "name": "Grid",
  "comment": "数据表格",
  "cssFiles": "style.pc.css",
  "attrs": [
    {
      "name": "dataBindSetting",
      "comment": "数据绑定设置",
      "type": "group",
      "items": [
        {
          "name": "loadDataService",
          "comment": "加载数据服务",
          "type": "Service"
        },
        {
          "name": "delDataService",
          "comment": "删除数据服务",
          "type": "Service"
        },
        {
          "name": "dataBindingMember",
          "comment": "绑定数据成员",
          "type": "String"
        },
        {
          "name": "dataBindingKey",
          "comment": "数据主键",
          "type": "String"
        }
      ]
    },
    {
      "name": "gridSetting",
      "comment": "数据表格设置",
      "type": "group",
      "items": [
      {
        "name": "columns",
        "comment": "数据列设置",
        "type": "Dataset",
        "isPro": true,
        "keyCol": "name",
        "width": "640px",
        "height": "600px",
        "columns": [
          {
            "id": "name",
            "name": "列名",
            "type": "String",
            "required": true
          },
          {
            "id": "width",
            "name": "宽度",
            "type": "Size",
            "width": "50px"
          },
          {
            "id": "align",
            "name": "对齐方式",
            "type": "Select",
            "width": "85px",
            "options": [
              {
                "value": "left",
                "text": "左对齐"
              },
              {
                "value": "center",
                "text": "居中对齐"
              },
              {
                "value": "right",
                "text": "右对齐"
              }
            ]
          },
          {
            "id": "color",
            "name": "文字颜色",
            "type": "Color",
            "width": "70px"
          },
          {
            "id": "bgColor",
            "name": "背景颜色",
            "type": "Color",
            "width": "70px"
          },
          {
            "id": "bold",
            "name": "加粗",
            "type": "Switch"
          },
          {
            "id": "sum",
            "name": "合计",
            "type": "Switch"
          },
          {
            "id": "format",
            "name": "数据绑定格式",
            "type": "String",
            "width": "150px",
            "wrap": true
          },
          {
            "id": "onClick",
            "name": "点击后执行的脚本",
            "type": "Event",
            "width": "180px",
            "wrap": true
          }
        ]
      },
      {
        "name": "rowHeight",
        "comment": "行高",
        "type": "Number"
      },
      {
        "name": "showHeader",
        "comment": "显示表头",
        "type": "Switch",
        "default": true
      },
      {
        "name": "showFooter",
        "comment": "显示表尾",
        "type": "Switch"
      },
      {
        "name": "showCheckbox",
        "comment": "显示选择框",
        "type": "Switch"
      },
      {
        "name": "allowPaging",
        "comment": "允许翻页",
        "type": "Switch",
        "default": false
      },
      {
        "name": "pageSize",
        "comment": "每页显示数量",
        "type": "Select",
        "options": [
          {
            "value": "20",
            "text": "20"
          },
          {
            "value": "30",
            "text": "30"
          },
          {
            "value": "50",
            "text": "50"
          },
          {
            "value": "100",
            "text": "100"
          }
        ]
      }
    ]
  }],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "400px",
    "height": "120px",
    "position": "relative",
    "left": 0,
    "top": 0
  },
  "events": [
    {
      "name": "onBeforeLoadData",
      "comment": "加载数据前"
    }, {
      "name": "onAfterLoadData",
      "comment": "加载数据后"
    }, {
      "name": "onAddDataRow",
      "comment": "添加数据行时"
    }
  ],
  "methods": [
    {
      "name": "gotoPage",
      "comment": "跳转到指定页",
      "args": [
        {
          "name": "toPage",
          "comment": "页数",
          "type": "Number",
          "required": true
        }
      ]
    },
    {
      "name": "addRow",
      "comment": "添加行",
      "args": [
        {
          "name": "rowData",
          "comment": "行数据",
          "type": "Object",
          "required": true
        }
      ]
    },
    {
      "name": "deleteRow",
      "comment": "删除行",
      "args": [
        {
          "name": "keyValue",
          "comment": "主键值",
          "type": "String",
          "required": true
        }
      ]
    },
    {
      "name": "bindData",
      "comment": "绑定数据",
      "args": [
        {
          "name": "data",
          "comment": "数据",
          "type": "Object",
          "required": true
        }
      ]
    },
    {
      "name": "loadData",
      "comment": "加载指定页的数据",
      "args": [
        {
          "name": "toPage",
          "comment": "页数",
          "type": "Number",
          "required": true
        }
      ]
    },
    {
      "name": "reloadData",
      "comment": "重新加载数据"
    },
    {
      "name": "getCheckedValues",
      "comment": "获得选中的值"
    },
    {
      "name": "getCheckedRows",
      "comment": "获得选中的行"
    }
  ]
}