import TFPComponentRender from '../render.js'

export default class GridRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let showTotal = false;
    let indent = this.getHtmlIndent();
    let htmlHeader = "\r\n"+indent+"\t<div class=\"tfp-grid-header\"{grid-head-display}>\r\n";
    htmlHeader += indent+"\t\t<div class=\"tfp-grid-header-row\" style=\"width:{grid-header-width}px;\">\r\n";
    let htmlRowTemplate = "\t\t\t<div class=\"tfp-grid-datarow tfp-grid-template-row\" style=\"width:{data-row-width};";
    let rowHeight = null;
    if(this.dataModel.rowHeight) {
      rowHeight = this.dataModel.rowHeight.indexOf("px")<0 ? 
        this.dataModel.rowHeight+"px" : this.dataModel.rowHeight;
      htmlRowTemplate += "height: "+rowHeight+";line-height:"+rowHeight+";";
    }
    htmlRowTemplate += "\">\r\n";
    
    this.cpt.rowWith = 0;
    let columns = this.dataModel.columns;
    if(!columns) {
      columns = [];
      if(this._tfp.isDesigning) {
        //不能直接修改this.columns，以免保存到tfp文件中
        columns = [{
          name: "列标题1",
          width: "100px",
          align: "center"
        },{
          name: "列标题1",
          width: "100px",
          align: "center"
        }];
      }
    }
    if(this.dataModel.showCheckbox) {
      htmlHeader += indent+"\t\t\t<div style=\"width:30px;\">"
        +"<input type=\"checkbox\" onclick=\"tfp.get('"
        +this.dataModel.id+"').checkAll(this)\" style=\"float:left; margin-left:10px; "
        +"margin-top:12px;\" /></div>\r\n";
      htmlRowTemplate += "\t\t<div class=\"tfp-grid-datarow-checkbox\">"
        +"<input type=\"checkbox\" /></div>";
      this.cpt.rowWith += 30;
    }
    for(var i=0;i<columns.length;i++) {
      let col = columns[i];
      htmlHeader += indent+"\t\t\t<div";
      if(col.class) htmlHeader += " class=\""+col.class+"\"";
      htmlHeader += " style=\"";
      let colWidth = this.cpt.getColWidth(col.width);
      htmlHeader += "width:"+colWidth+";"
      //TODO 列宽暂不支持百分比的精确计算，只是简单的把%替换掉了
      this.cpt.rowWith += parseInt(colWidth.replace("px", "").replace("%", ""));
      if(col.align && col.align!="center") htmlHeader += "text-align:"+col.align+";"
      //if(col.color) htmlHeader += "color:"+col.color+";"
      //if(col.bgColor) htmlHeader += "background-color:"+col.bgColor+";"
      //if(col.bold) htmlHeader += "font-weight: bold;"
      //if(col.fontSize) htmlHeader += "font-size: "+col.fontSize+";"
      //if(col.style) htmlHeader += col.style;
      htmlHeader += "\">"+col.name+"</div>\r\n";
      if(col.sum) showTotal = true;

      htmlRowTemplate += "\t\t\t\t<div";
      if(col.class) htmlRowTemplate += " class=\""+col.class+"\"";
      htmlRowTemplate += " style=\"width:"+colWidth+";"
      if(rowHeight) htmlRowTemplate += "height: "+rowHeight+";";
      if(col.align) htmlRowTemplate += "text-align:"+col.align+";"
      if(col.color) htmlRowTemplate += "color:"+col.color+";"
      if(col.bgColor) htmlRowTemplate += "background-color:"+col.bgColor+";"
      if(col.bold) htmlRowTemplate += "font-weight: bold;"
      if(col.fontSize) htmlRowTemplate += "font-size: "+col.fontSize+";"
      if(col.onclick) htmlRowTemplate += "cursor: pointer;";
      if(col.style) htmlRowTemplate += col.style;
      htmlRowTemplate += "\">";
      if(col.format) htmlRowTemplate += col.format;
      htmlRowTemplate += "</div>\r\n";
    }
    htmlHeader += indent+"\t\t</div>\r\n";
    htmlHeader += indent+"\t</div>\r\n";
    htmlHeader = htmlHeader.replace("{grid-header-width}", this.cpt.rowWith);
    let html = "";
    if(this.dataModel.showHeader) {
      html += htmlHeader.replace("{grid-head-display}", "");
    } else if(this._tfp.isDesigning) {
      html += htmlHeader.replace("{grid-head-display}", " style=\"display:none;\"");
    }
    htmlRowTemplate += "\t\t\t</div>\r\n";
    htmlRowTemplate = htmlRowTemplate.replace("{data-row-width}", this.cpt.rowWith);
    html += indent+"\t<div class=\"tfp-grid-datalist\" style=\"bottom:{data-list-bottom}px;\">\r\n";
    if(this._tfp.isDesigning) html += htmlRowTemplate;
    html += indent+"\t</div>\r\n";
    let dataListBottom = 0;
    if(showTotal) {
      html += indent+"\t<div class=\"tfp-grid-total\">\r\n";
      html += indent+"\t</div>\r\n";
      dataListBottom += 41;
    }
    html += this.cpt.getFooterHtml();
    if(this.dataModel.showFooter) dataListBottom += 51;
    html = html.replace("{data-list-bottom}", dataListBottom);
    return html;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", getComponentsHtml, parentIndent, retainStyleAttr);
  }
}