import TFPComponentRender from '../render.js'

export default class GridDataRowRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let bodyHtml = "\r\n";
    bodyHtml += this.cpt.getSearchBoxHtml();
    var indent = this.cpt.getHtmlIndent();
    bodyHtml += indent+"\t<div class=\"tfp-grid-datalist\">\r\n";
    if(this.dataModel.components && getComponentsHtml) {
      let cdm = this.dataModel.components[0];
      this.cpt.setCptDataFormat(cdm);
      bodyHtml += this.getComponentsHtml(true, indent, true);
      if(!this._tfp.isDesigning) {
        bodyHtml = bodyHtml.replace("tfp-griddatarow", "tfp-griddatarow-template");
        bodyHtml = this.cpt.deleteCptId(bodyHtml);
      }
    }

    bodyHtml += indent+"\t</div>\r\n";
    bodyHtml += this.cpt.getFooterHtml();
    return bodyHtml+indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", getComponentsHtml, parentIndent, retainStyleAttr);
  }
}