import TFPComponentRender from '../render.js'

export default class HiddenRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getHtml = function(getComponentsHtml, parentIndent) {
    let indent = this.getHtmlIndent();
    if(this._tfp.isDesigning) {
      return indent+"<img id=\""+this.dataModel.id+"\" "
        +"src=\""+this._tfp.rootPath+"/src/components/hidden/images/icon-24-dark.png\" style=\"float:right;\">\r\n";
    } else {
      let cptHtml = indent+"<input id=\""+this.dataModel.id+"\" type=\"hidden\"";
      if(this.dataModel.value) cptHtml += " value=\""+this.dataModel.value+"\"";
      cptHtml += " />\r\n";
      return cptHtml;
    }
  }
}