import {VisibleComponent} from "../controller.js";

/**
 * 嵌入框架组件
 * @param {[type]} dataModel [description]
 */
export default class Iframe extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Iframe", dataModel, parent);
  }

  //属性
  get src() { return this.dataModel.src }
  set src(value) { 
    this.dataModel.src = value;
    if(this._jqObj) {
      if(this._tfp.isDesigning) {
        this._jqObj.find("iframe").attr("src", value);
      } else {
        this._jqObj.attr("src", value);
      }
    }
  }

  get scrolling() { return this.dataModel.scrolling }
  set scrolling(value) { 
    this.dataModel.scrolling = value;
    if(this._jqObj) {
      if(this._tfp.isDesigning) {
        this._jqObj.find("iframe").attr("scrolling", value);
      } else {
        this._jqObj.attr("scrolling", value);
      }
    }
  }

  get frameBorder() { 
    return this.dataModel.frameBorder ? this.dataModel.frameBorder : 0; 
  }
  set frameBorder(value) { 
    this.dataModel.frameBorder = value;
    if(this._jqObj) {
      if(this._tfp.isDesigning) {
        this._jqObj.find("iframe").attr("frameBorder", value);
      } else {
        this._jqObj.attr("frameBorder", value);
      }
    }
  }

  get marginWidth() { 
    return this.dataModel.marginWidth ? this.dataModel.marginWidth : 0; 
  }
  set marginWidth(value) { 
    this.dataModel.marginWidth = value;
    if(this._jqObj) {
      if(this._tfp.isDesigning) {
        this._jqObj.find("iframe").attr("marginWidth", value);
      } else {
        this._jqObj.attr("marginWidth", value);
      }
    }
  }

  get marginHeight() { 
    return this.dataModel.marginHeight ? this.dataModel.marginHeight : 0; 
  }
  set marginHeight(value) { 
    this.dataModel.marginHeight = value;
    if(this._jqObj) {
      if(this._tfp.isDesigning) {
        this._jqObj.find("iframe").attr("marginHeight", value);
      } else {
        this._jqObj.attr("marginHeight", value);
      }
    }
  }
}