import {VisibleComponent} from "../controller.js";

/**
 * 图片组件
 * @param {[type]} dataModel [description]
 */
export default class Image extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Image", dataModel, parent);
  }

  get src() { return this.dataModel.src }
  set src(value) { 
    this.dataModel.src = value;
    if(this._jqObj) {
      let src = value;
      if(this._tfp.isDesigning && src) src = this._tfp.getUrlRealPath(src);
      this._jqObj.attr("src", src);
    }
  }

  get title() { return this.dataModel.title }
  set title(value) { 
    this.dataModel.title = value;
    if(this._jqObj) {
      this._jqObj.attr("title", value);
    }
  }

  get dataBindingFormat() { return this.dataModel.dataBindingFormat }
  set dataBindingFormat(value) { this.dataModel.dataBindingFormat = value }
}