import TFPComponentRender from '../render.js'

export default class ImageRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getAttrHtml() {
    let attrHtml = super.getAttrHtml();
    let src = this.dataModel.src;
    let imgUrl = this.dataModel.src;
    if(!imgUrl) {
      imgUrl = this._tfp.rootPath+"/src/components/image/images/default-photo.png";
    } else if(this._tfp.isDesigning) {
      imgUrl = this._tfp.getUrlRealPath(imgUrl);
    }
    attrHtml += " src=\""+imgUrl+"\"";
    return attrHtml;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("img", false, parentIndent, retainStyleAttr);
  }
}