import {FormInput} from "../controller.js";

/**
 * 组织结构组件
 * @param {[type]} dataModel [description]
 */
export default class Org extends FormInput {

  constructor(__tfp, inputType, dataModel, parent) {
    super(__tfp, inputType, dataModel, parent);
  }

  get value() { return this.dataModel.value }
  set value(value) { 
    this.dataModel.value = value;
    if(this._jqObj) {
      this._jqObj.find("input").val(value);
    }
    if(!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  get iconUrl() {
    return this._tfp.rootPath+"/src/components/"
      +this.dataModel.type.toLowerCase()+"/images/icon-24-"
      +this._tfp.curPage.contentColorMode+".png";
  }
  set iconUrl(value) {}

  get showIcon() { return this.dataModel.showIcon }
  set showIcon(value) { 
    this.dataModel.showIcon = value ? true : false;
    if(this._jqObj) {
      if(this.dataModel.showIcon) {
        if(this._jqObj.find("img").length==0) {
          this._jqObj.append("<img src=\""+this.iconUrl+"\" />");
        }
      } else {
        this._jqObj.find("img").remove();
      }
      let iptWidth = "100%";
      if(this.dataModel.showIcon) iptWidth = "calc(100% - 30px)";
      this._jqObj.find("input").css("width", iptWidth+"px");
    }
  }

  get valueType() { return this.dataModel.valueType }
  set valueType(value) { 
    if(!this.checkAttrOption("valueType", value)) {
      this._tfp.showMsg("不支持类型："+value+"！");
      return;
    }
    this.dataModel.valueType = value;
  }

  get multiCheck() { return this.dataModel.multiCheck }
  set multiCheck(value) { 
    this.dataModel.multiCheck = value ? true : false;
  }

  showPicker() {
    if(this.dataModel.type=="Dep") {
      if(this.dataModel.multiCheck) {
        this._tfp.openDialog("选择部门", this._tfp.rootPath+"/src/components/org/tfp/depsPicker.tfp?valueType=obj&cptId="+this.id, "480px", "480px");
      } else {
        this._tfp.openDialog("选择部门", this._tfp.rootPath+"/src/components/org/tfp/depPicker.tfp?valueType=obj&cptId="+this.id, "480px", "480px");
      }
    } else if(this.dataModel.type=="User") {
      if(this.dataModel.multiCheck) {
        this._tfp.openDialog("选择用户", this._tfp.rootPath+"/src/components/org/tfp/usersPicker.tfp?valueType=obj&cptId="+this.id, "480px", "480px");
      } else {
        this._tfp.openDialog("选择用户", this._tfp.rootPath+"/src/components/org/tfp/userPicker.tfp?valueType=obj&cptId="+this.id, "480px", "480px");
      }
    } else if(this.dataModel.type=="Role") {
      if(this.dataModel.multiCheck) {
        this._tfp.openDialog("选择群组", this._tfp.rootPath+"/src/components/org/tfp/rolesPicker.tfp?valueType=obj&cptId="+this.id, "480px", "480px");
      } else {
        this._tfp.openDialog("选择群组", this._tfp.rootPath+"/src/components/org/tfp/rolePicker.tfp?valueType=obj&cptId="+this.id, "480px", "480px");
      }
    }
  }

  onSelected(ret) {
    if(this.dataModel.valueType=="obj") {
      this.value = ret;
    } else {
      if(this.dataModel.multiCheck) {
        let val = "";
        for(var i=0;i<ret.length;i++) {
          if(val!="") val += ",";
          val += ret[i].id;
        }
        this.value = val;
      } else {
        this.value = ret.id;
      }
    }
    if(this.dataModel.multiCheck) {
      let names = "";
      for(var i=0;i<ret.length;i++) {
        if(names!="") names += ",";
        names += ret[i].name;
      }
      this._jqObj.find("input").val(names);
    } else {
      this._jqObj.find("input").val(ret.name);
    }
  }

  initRuntime() {
    let that = this;
    this._jqObj.click(function(){
      if(that.readonly || that.disabled) return;
      that.showPicker();
    });
  }
}