import TFPComponentRender from '../render.js'

export default class OrgRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getBodyHtml = function(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let val = "";
    if(this.dataModel.value) val = this.dataModel.value;
    html += indent+"\t<input type=\"text\" readonly value=\""+val+"\"/>\r\n";
    if(this.cpt.showIcon) html += indent+"\t<img src=\""+this.cpt.iconUrl+"\" />\r\n";
    return html+indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}