import FileUpload from "../fileupload/controller.js";

/**
 * 图片上传组件
 * @param {[type]} dataModel [description]
 */
export default class PhotoUpload extends FileUpload {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, dataModel, parent, "PhotoUpload");
  }

  //保持唯一
  get onlyOne() { return this.dataModel.onlyOne }
  set onlyOne(value) {this.dataModel.onlyOne = value }

  get imageWidth() { return this.dataModel.imageWidth }
  set imageWidth(value) { 
    this.dataModel.imageWidth = value;
    if(this._jqObj) {
      this._jqObj.find(".tfp-photoupload-image").find("img").css("width", value+"px");
    }
  }

  get imageHeight() { return this.dataModel.imageHeight }
  set imageHeight(value) { 
    this.dataModel.imageHeight = value;
    if(this._jqObj) {
      this._jqObj.find(".tfp-photoupload-image").find("img").css("height", value+"px");
    }
  }

  get imageMargin() { return this.dataModel.imageMargin }
  set imageMargin(value) { 
    this.dataModel.imageMargin = value;
    if(this._jqObj) {
      this._jqObj.find(".tfp-photoupload-image").find("img").css("margin", value+"px");
    }
  }

  selectFile() {
    if(!this.size) this.size = 10;
    if(this.size && this.files && this.files.length>=this.size) {
      this._tfp.showMsg("最多只能上传"+this.size+"张图片！");
      return;
    }
    let imagesDiv = this._jqObj.find(".tfp-photoupload-images");
    imagesDiv.append("<div class=\"tfp-photoupload-image\" style=\"margin:"
      +this.dataModel.imageMargin+"px;display:none\">"
      +"<img width=\""+this.dataModel.imageWidth+"\" height=\""+this.dataModel.imageHeight+"\" />"
      +"<input type=\"file\" style=\"display:none\" />"
      +"<p><progress value=\"0\" max=\"100\"></progress>&nbsp;"
      +"<span class=\"uploaderPercent\">0%</span></p></div>");
    let that = this;
    let ipt = imagesDiv.find(".tfp-photoupload-image").last().find("input");
    ipt.change(function() {
      that.uploadFile(this);
    });
    ipt.click();
  }

  initRuntime() {
    let that = this;
    this._jqObj.find(".tfp-photoupload-row").find("input").click(function() {
      that.selectFile();
    });
  }
}