export default {
  "name": "PhotoUpload",
  "comment": "图片上传",
  "cssFiles": ["style.css", "../button/style.{bgColorMode}.css"],
  "attrs": [
    {
      "name": "appCode",
      "comment": "应用代码",
      "type": "String"
    },
    {
      "name": "appDataId",
      "comment": "应用数据ID",
      "type": "String"
    },
    {
      "name": "onlyOne",
      "comment": "保持唯一",
      "type": "Switch",
      "default": true
    },
    {
      "name": "size",
      "comment": "文件总数",
      "type": "Number",
      "default": 10
    },
    {
      "name": "imageWidth",
      "comment": "图片宽度",
      "type": "Number",
      "required": true,
      "default": "90"
    },
    {
      "name": "imageHeight",
      "comment": "图片高度",
      "type": "Number",
      "required": true,
      "default": "90"
    },
    {
      "name": "imageMargin",
      "comment": "图片边距",
      "type": "Number",
      "required": true,
      "default": "10"
    },
    {
      "name": "allowDelete",
      "comment": "允许删除",
      "type": "Switch",
      "default": true
    }
  ],
  "styles": ["size", "position", "font", "background", "margin", "border", "other"],
  "events": [{
    "name": "onClick", 
    "comment": "点击时"
  }, {
    "name": "onChange",
    "comment": "值发生变化时"
  }]
}