import FileUploadRender from '../fileupload/render.js'

export default class PhotoUploadRender extends FileUploadRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    if(this._tfp.isDesigning) {
      html += indent+"\t<input type=\"button\" value=\"上传图片\" "
        +"class=\"tfp-button tfp-button-primary\" style=\"line-height:30px;\" />\r\n";
    } else {
      html += indent+"\t<div class=\"tfp-photoupload-row\">"
        +"<p><input type=\"button\" value=\"上传图片\" "
        +"class=\"tfp-button tfp-button-primary\" style=\"line-height:30px;\" /></p>"
        +"</div>\r\n";
      html += indent+"\t<div class=\"tfp-photoupload-images\">\r\n";
      if(this.dataModel.value) {
        for(var i=0;i<this.dataModel.value.length;i++) {
          let fileInfo = this.dataModel.value[i];
          html += indent+"\t\t<div class=\"tfp-photoupload-image\" "
            +"style=\"margin:"+this.dataModel.imageMargin+"px; \">"
            +"<img src=\"/Download?fileCode="+fileInfo.code+"\" width=\""
            +this.dataModel.imageWidth+"\" height=\""+this.dataModel.imageHeight+"\" /></div>\r\n";
        }
      }
      html += indent+"\t</div>\r\n";
    }
    return html+indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}