import TFPComponentRender from '../render.js'

export default class RadioRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    for(var i=0;i<this.dataModel.options.length;i++) {
      var option = this.dataModel.options[i];
      bodyHtml += this.cpt.getOptionHtml(indent, option);
      if(i<(this.dataModel.options.length-1) && this.dataModel.portrait) 
        bodyHtml += indent+"\t<br>\r\n";
    }
    return bodyHtml+indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}