import {FormInput} from "../controller.js";

/**
 * 富文本组件
 * @param {[type]} dataModel [description]
 */
export default class RichText extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "RichText", dataModel, parent);
  }

  //属性
  get value() { 
    if(!this._tfp.isDesigning && this.editor) this.dataModel.value = this.editor.html();
    if(!this.dataModel.value) return "";
    return this.dataModel.value;
  }
  set value(value) { 
    this.dataModel.value = value;
    if(this._jqObj && !this._tfp.isDesigning) {
      this.editor.html(value);
    }
    if(!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  get dataBindingFormat() { return this.dataModel.dataBindingFormat }
  set dataBindingFormat(value) { 
    this.dataModel.dataBindingFormat = value;
  }

  initRuntime() {
    let that = this;
    var uploadUrl = "/Upload?appCode=KindEditor";
    if(top.taskMsgAuthObj) uploadUrl = tfp.setUrlAuthData(uploadUrl);
    var options = {
      allowImageUpload : true,
      allowFlashUpload : false,
      allowMediaUpload : false,
      designMode : true,
      allowFileManager : false,
      uploadJson : uploadUrl,
      resizeType: 0,
      width: this._jqObj.width()+"px",
      height: this._jqObj.height()+"px",
      afterBlur: function() {
        that.dataModel.value = that.editor.html();
        that.valueOnChange();
        that.exeEventHandler("onChange", that.dataModel.value);
      }
    };
    this.editor = KindEditor.create("#"+this.id+"_textarea", options);
    this.css("border", "0");
    if(this.value) this.editor.html(this.value);
  }
}