export default {
  "name": "RichText",
  "comment": "富文本",
  "cssFiles": [
    {
      "src": "/inc/kde/themes/default/default.css",
      "onlyRuntime": true
    }
  ],
  "jsFiles": [
    {
      "src": "/inc/kde/kindeditor-min.js",
      "onlyRuntime": true
    }, 
    {
      "src": "/inc/kde/lang/zh_CN.js",
      "onlyRuntime": true
    }
  ],
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "文本内容",
          "type": "String"
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "formula",
          "comment": "自动计算表达式",
          "type": "Formula"
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        },
        {
          "name": "readonly",
          "comment": "只读",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "disabled",
          "comment": "禁用",
          "type": "Switch",
          "isHtmlAttr": true
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "border": "1px solid #cccccc",
    "width": "300px",
    "height": "220px",
    "background-color": "#FFFFFF"
  },
  "events": [{
    "name": "onClick", 
    "comment": "点击时"
  }, {
    "name": "onFocus",
    "comment": "获得焦点时"
  }, {
    "name": "onBlur",
    "comment": "失去焦点时"
  }, {
    "name": "onChange",
    "comment": "值发生变化时"
  }]
}