import {FormInput} from "../controller.js";

/**
 * 下拉列表组件
 * @param {[type]} dataModel [description]
 */
export default class Select extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Select", dataModel, parent);
  }

  //属性
  get value() { 
    if(!this._tfp.isDesigning && this._jqObj) 
      this.dataModel.value = this._jqObj.val();
    if(!this.dataModel.value) return "";
    return this.dataModel.value;
  }
  set value(value) { 
    this.dataModel.value = value;
    if(this._jqObj && !this._tfp.isDesigning) {
      this._jqObj.val(value);
    }
    if(!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  get options() { return this.dataModel.options }
  set options(value) {
    if(this._tfp.isDesigning) {
      this.dataModel.options = value;
      return;
    }
    if(this._jqObj && value && Array.isArray(value)) {
      this._jqObj.empty();
      this.dataModel.options = [];
      if(!this.required) this._jqObj.append("<option value=\"\"></option>");
      for(var i=0;i<value.length;i++) {
        this.addOption(value[i]);
      }
      //TODO 如果重置选项列表后，没有组件当前值对应的选项，应该把组件值设置为空
    }
  }

  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) {this.dataModel.loadDataService = value}

  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) {this.dataModel.dataBindingMember = value}

  get valueField() { return this.dataModel.valueField }
  set valueField(value) {this.dataModel.valueField = value}

  get textField() { return this.dataModel.textField }
  set textField(value) {this.dataModel.textField = value}

  addOption(option) {
    if(!option) return;
    let opt = option;
    if(typeof(opt)=="string") opt = {value: option, text: option};
    if(!this.dataModel.options) this.dataModel.options = [];
    this.dataModel.options.push(opt);
    let txt = opt.text;
    if(!txt) txt = opt.value;
    this._jqObj.append("<option value=\""+opt.value+"\">"+txt+"</option>");
    if(opt.value==this.dataModel.value) this._jqObj.val(opt.value);
  }

  bindData(data) {
    if(isNull(data) || !Array.isArray(data)) return;
    let optionsTmp = [];
    for(var i=0;i<data.length;i++) {
      let row = data[i];
      let option = {};
      try {
        option.value = this._tfp.replaceDataField(row, "{"+this.dataModel.valueField+"}");
      } catch(e) {
        console.log(e);
        return;
      }
      if(isNull(option.value)) continue;
      if(this.dataModel.textField) {
        try {
          option.text = this._tfp.replaceDataField(row, "{"+this.dataModel.textField+"}");
        } catch(e) {
          console.log(e);
          return;
        }
      }
      optionsTmp.push(option);
    }
    this.options = optionsTmp;
  }

  loadData() {
    if(!this.dataModel.loadDataService) {
      alert("请为["+this.id+"]设置加载数据服务！");
      return;
    }
    let serviceCpt = this._tfp.get(this.dataModel.loadDataService);
    if(!serviceCpt) {
      alert("ID为["+this.dataModel.loadDataService+"]的组件不存在！");
      return;
    }
    if(!this.dataModel.dataBindingMember) {
      alert("请为["+this.id+"]设置数据绑定成员！");
      return;
    }
    if(!this.dataModel.valueField) {
      alert("请为["+this.id+"]设置选项值字段格式！");
      return;
    }

    let that = this;
    //与服务组件建立绑定
    if(!serviceCpt.bindCpts) serviceCpt.bindCpts = [];
    if(!serviceCpt.bindCpts.contains(this.id)) serviceCpt.bindCpts.push(this.id);
    serviceCpt.request(null, function(req, res) {
      var data = res[that.dataModel.dataBindingMember];
      that.bindData(data);
    });
  }

  initRuntime() {
    if(this.dataModel.loadDataService) {
      this.loadData();
    }

    let that = this;
    this._jqObj.change(function(){
      that.dataModel.value = $(this).val();
      that.valueOnChange();
      that.exeEventHandler("onChange", that.dataModel.value);
    });
  }
}