export default {
  "name": "Select",
  "comment": "下拉列表",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "组件值",
          "type": "String"
        },
        {
          "name": "options",
          "comment": "选项",
          "type": "Dataset"
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "formula",
          "comment": "自动计算表达式",
          "type": "Formula"
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        },
        {
          "name": "readonly",
          "comment": "只读",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "disabled",
          "comment": "禁用",
          "type": "Switch",
          "isHtmlAttr": true
        }
      ]
    },
    {
      "name": "dataSourceSetting",
      "comment": "数据源设置",
      "type": "group",
      "items": [
        {
          "name": "loadDataService",
          "comment": "数据加载服务",
          "type": "Service"
        },
        {
          "name": "dataBindingMember",
          "comment": "数据绑定成员",
          "type": "String"
        },
        {
          "name": "valueField",
          "comment": "选项值字段",
          "type": "String"
        },
        {
          "name": "textField",
          "comment": "选项文本字段",
          "type": "String"
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "specialStyles": ["width", "height"],
  "defaultStyles": {
    "width": "80px",
    "height": "30px",
    "line-height": "30px",
    "padding-left": "2px",
    "padding-right": "2px"
  },
  "events": [{
    "name": "onClick", 
    "comment": "点击时"
  }, {
    "name": "onFocus",
    "comment": "获得焦点时"
  }, {
    "name": "onBlur",
    "comment": "失去焦点时"
  }, {
    "name": "onChange",
    "comment": "值发生变化时"
  }],
  "methods": [{
    "name": "setOptions",
    "comment": "设置可选项",
    "args": [{
      "name": "options",
      "comment": "可选项",
      "type": "String"
    }]
  },{
    "name": "addOption",
    "comment": "添加选项",
    "args": [{
      "name": "option",
      "comment": "选项",
      "type": "Object"
    }]
  }]
}