export default {
  "name": "Switch",
  "comment": "开关",
  "cssFiles": "style.css",
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "组件值",
          "type": "String"
        },
        {
          "name": "options",
          "comment": "选项",
          "type": "Dataset",
          "count": 2,
          "columns": [
            {
              "id": "value",
              "name": "可选值",
              "type": "String",
              "required": true
            }
          ],
          "default": [false, true]
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "formula",
          "comment": "自动计算表达式",
          "type": "Formula"
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        }
      ]
    }
  ],
  "styles": ["position", "margin", "other"],
  "events": [{
    "name": "onClick", 
    "comment": "点击时"
  }, {
    "name": "onChange",
    "comment": "值发生变化时"
  }]
}