import {ContainerComponent} from "../controller.js";

/**
 * 选项卡组件
 * @param {[type]} dataModel [description]
 */
export default class Tab extends ContainerComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Tab", dataModel, parent);

    if(!this.dataModel.components || this.dataModel.components.length==0) {
      this.dataModel.components = [{
        id: this.id+"_page1",
        type: "TabPage",
        title: "page1"
      }, {
        id: this.id+"_page2",
        type: "TabPage",
        title: "page2",
        styles: {
          display: "none"
        }
      }];
    }
  }

  get pages() { 
    var pages = [];
    for(var i=0; i<this.dataModel.components.length;i++) {
      let tabPageDM = this.dataModel.components[i];
      pages.push({id: tabPageDM.id, type: "TabPage", title: tabPageDM.title});
    }
    return pages;
  }
  set pages(value) { 
    let pages = [];
    if(value) pages = value;
    let tabPages = [];
    if(this.dataModel.pageIndex>=pages.length) this.dataModel.pageIndex = pages.length-1;
    if(this.dataModel.pageIndex<0) this.dataModel.pageIndex = 0;
    for(var i=0;i<pages.length;i++) {
      let page = pages[i];
      let cdm = null;
      if(page.id) {
        let tabPage = this._tfp.components[page.id];
        cdm = tabPage.dataModel;
        cdm.title = page.title;
        if(cdm.styles && cdm.styles.display) delete cdm.styles["display"];
        delete this._tfp.components[tabPage.id];
      } else {
        cdm = {
          type: "TabPage",
          title: page.title
        };
      }
      if(i!=this.dataModel.pageIndex) {
        if(cdm.styles) {
          cdm.styles.display = "none";
        } else {
          cdm.styles = {display: "none"};
        }
      }
      tabPages.push(cdm);
    }
    this.dataModel.components = tabPages;
    this._jqObj.remove();
    this.render();
    if(this.dataModel.components.length>0) this.showTabPage(0);
  }

  get pageIndex() { return this.dataModel.pageIndex }
  set pageIndex(value) { 
    this.dataModel.pageIndex = value;
    if(this._jqObj) this.showTabPage(value);
  }

  get titleWidth() { return this.dataModel.titleWidth }
  set titleWidth(value) { 
    this.dataModel.titleWidth = value;
    if(this._jqObj) {
      this._jqObj.find(".tfp-tab-head").css("width", value);
    }
  }

  get titleHeight() { return this.dataModel.titleHeight }
  set titleHeight(value) { 
    this.dataModel.titleHeight = value;
    if(this._jqObj) {
      this._jqObj.find(".tfp-tab-head").css("height", value);
    }
  }

  get containerEl() {
    return this._jqObj.find(".tfp-tab-pages").get(0);
  }

  showTabPage(index) {
    this._jqObj.find(".tfp-tabpage").hide();
    this._jqObj.find(".tfp-tab-title").removeClass("tfp-tab-title-selected");
    this._jqObj.find(".tfp-tabpage").eq(index).show();
    this._jqObj.find(".tfp-tab-title").eq(index).addClass("tfp-tab-title-selected");
    if(!this._tfp.isDesigning) {
      this.dataModel.pageIndex = index;
      for(var i=0;i<this.dataModel.components.length;i++) {
        let tabPageDM = this.dataModel.components[i];
        if(i==index) {
          if(tabPageDM.styles) delete tabPageDM.styles["display"];
        } else {
          if(!tabPageDM.styles) tabPageDM.styles = {};
          tabPageDM.styles["display"] = "none";
        }
      }
    }
    //this.exeEventHandler("onTabIndexChange");
    if(this.dataModel.onTabIndexChange && !this._tfp.isDesigning) 
      eval(this.dataModel.onTabIndexChange);
    //window.event.stopPropagation();
  }
}