import TFPComponentRender from '../render.js'

export default class TabRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getBodyHtml = function(getComponentsHtml) {
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    bodyHtml += indent+"\t<div class=\"tfp-tab-head\" style=\"height:"
      +(this.dataModel.titleHeight+1)+"px;\">\r\n";
    if( //(!this._tfp.isDesigning) && 
      this.dataModel.components) {
      for(var i=0;i<this.dataModel.components.length;i++) {
        let tabPageDM = this.dataModel.components[i];
        bodyHtml += indent+"\t\t<div class=\"tfp-tab-title";
        if(i==this.dataModel.pageIndex) {
          bodyHtml += " tfp-tab-title-selected";
        } else {
          if(!tabPageDM.styles) tabPageDM.styles = {};
          tabPageDM.styles["display"] = "none";
        }
        bodyHtml += "\" style=\"min-width:"+this.dataModel.titleWidth+"px;height:"
          +this.dataModel.titleHeight+"px;line-height:"+this.dataModel.titleHeight+"px;\" "
          +"onclick=\"tfp.get('"+this.dataModel.id+"').showTabPage("+i+")\">"
          +tabPageDM.title+"</div>\r\n";
      }
    }
    bodyHtml += indent+"\t</div>\r\n";
    bodyHtml += indent+"\t<div class=\"tfp-tab-pages\" style=\"top:"
      +(parseInt(this.dataModel.titleHeight)+1)+"px;\">\r\n";
    if(this.dataModel.components && getComponentsHtml) {
      bodyHtml += this.getComponentsHtml(getComponentsHtml, indent);
    }
    bodyHtml += indent+"\t</div>\r\n";
    return bodyHtml+indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", getComponentsHtml, parentIndent, retainStyleAttr);
  }
}