export default {
  "name": "Text",
  "comment": "单行文本",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "文本内容",
          "type": "String",
          "isHtmlAttr": true
        },
        {
          "name": "maxLength",
          "comment": "最大长度",
          "type": "Int",
          "isHtmlAttr": true
        },
        {
          "name": "placeHolder",
          "comment": "输入提示",
          "type": "String",
          "isHtmlAttr": true
        },
        {
          "name": "dataType",
          "comment": "数据类型",
          "type": "Select",
          "default": "text",
          "options": [
            {
              "value": "text",
              "text": "文本"
            },
            {
              "value": "int",
              "text": "整数"
            },
            {
              "value": "float",
              "text": "小数"
            },
            {
              "value": "money",
              "text": "金额"
            }
          ]
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "formula",
          "comment": "自动计算表达式",
          "type": "Formula"
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        },
        {
          "name": "readonly",
          "comment": "只读",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "disabled",
          "comment": "禁用",
          "type": "Switch",
          "isHtmlAttr": true
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "120px",
    "height": "30px",
    "line-height": "30px",
    "padding-left": "2px",
    "padding-right": "2px"
  },
  "events": [{
    "name": "onClick", 
    "comment": "点击时"
  }, {
    "name": "onFocus",
    "comment": "获得焦点时"
  }, {
    "name": "onBlur",
    "comment": "失去焦点时"
  }, {
    "name": "onChange",
    "comment": "值发生变化时"
  }]
}