import {FormInput} from "../controller.js";

/**
 * 多行文本组件
 * @param {[type]} dataModel [description]
 */
export default class TextArea extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "TextArea", dataModel, parent);
  }

  get value() { 
    if(!this.dataModel.value) return "";
    return this.dataModel.value; 
  }
  set value(value) {
    this.dataModel.value = value;
    if(this._jqObj) {
      this._jqObj.val(value);
    }
    if(!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  /*get cols() { return this.dataModel.cols }
  set cols(value) { 
    this.dataModel.cols = value;
    if(this._jqObj) this._jqObj.attr("cols", value);
  }

  get rows() { return this.dataModel.rows }
  set rows(value) { 
    this.dataModel.rows = value;
    if(this._jqObj) this._jqObj.attr("rows", value);
  }*/

  get maxLength() { return this.dataModel.maxLength }
  set maxLength(value) { 
    this.dataModel.maxLength = value;
    if(this._jqObj) this._jqObj.attr("maxlength", value);
  }

  get placeHolder() { return this.dataModel.placeHolder }
  set placeHolder(value) { 
    this.dataModel.placeHolder = value;
    if(this._jqObj) this._jqObj.attr("placeholder", value);
  }

  get format() { return this.dataModel.format }
  set format(value) { 
    this.dataModel.format = value;
  }

  initRuntime() {
    let that = this;
    this._jqObj.change(function() {
      that.dataModel.value = that._jqObj.val();
      that.valueOnChange();
      that.exeEventHandler("onChange", that.dataModel.value);
    });
  }
}