/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.ranged;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.client.BooleanItemPropertyGetter;
import slimeknights.tconstruct.library.events.ProjectileEvent;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IAmmoUser;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.library.tools.ranged.IAmmo;
import slimeknights.tconstruct.library.tools.ranged.ILauncher;
import slimeknights.tconstruct.library.tools.ranged.ProjectileLauncherCore;
import slimeknights.tconstruct.library.utils.AmmoHelper;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.ranged.TinkerRangedWeapons;

public abstract class BowCore
extends ProjectileLauncherCore
implements IAmmoUser,
ILauncher {
    protected static final UUID LAUNCHER_BONUS_DAMAGE = UUID.fromString("066b8892-d2ac-4bae-ac22-26f9f91a02ee");
    protected static final UUID LAUNCHER_DAMAGE_MODIFIER = UUID.fromString("4f76565a-3845-4a09-ba8f-92a37937a7c3");
    protected static final ResourceLocation PROPERTY_PULL_PROGRESS = new ResourceLocation("pull");
    protected static final ResourceLocation PROPERTY_IS_PULLING = new ResourceLocation("pulling");
    protected final IItemPropertyGetter pullProgressPropertyGetter;
    protected final IItemPropertyGetter isPullingPropertyGetter;

    public BowCore(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(Category.LAUNCHER);
        this.pullProgressPropertyGetter = new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return BowCore.this.getDrawbackProgress(itemstack, entityIn);
            }
        };
        this.isPullingPropertyGetter = new BooleanItemPropertyGetter(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean applyIf(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack;
            }
        };
    }

    protected float baseInaccuracy() {
        return 0.0f;
    }

    protected float baseProjectileSpeed() {
        return 3.0f;
    }

    public int getDrawTime() {
        return 20;
    }

    public float getDrawbackProgress(ItemStack itemstack, EntityLivingBase entityIn) {
        if (itemstack.func_77973_b() == this) {
            int timePassed = itemstack.func_77988_m() - entityIn.func_184605_cv();
            return this.getDrawbackProgress(itemstack, timePassed);
        }
        return 0.0f;
    }

    protected float getDrawbackProgress(ItemStack itemStack, int timePassed) {
        float drawProgress = ProjectileLauncherNBT.from((ItemStack)itemStack).drawSpeed * (float)timePassed;
        return Math.min(1.0f, drawProgress / (float)this.getDrawTime());
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (!ToolHelper.isBroken(itemStackIn)) {
            boolean hasAmmo = !this.findAmmo(itemStackIn, (EntityLivingBase)playerIn).func_190926_b();
            ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemStackIn, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)hand, (boolean)hasAmmo);
            if (ret != null) {
                return ret;
            }
            if (playerIn.field_71075_bZ.field_75098_d || hasAmmo) {
                playerIn.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (ToolHelper.isBroken(stack) || !(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        ItemStack ammo = this.findAmmo(stack, entityLiving);
        if (ammo.func_190926_b() && !player.field_71075_bZ.field_75098_d) {
            return;
        }
        int useTime = this.func_77626_a(stack) - timeLeft;
        if ((useTime = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)player, (int)useTime, (!ammo.func_190926_b() ? 1 : 0) != 0)) < 5) {
            return;
        }
        if (ammo.func_190926_b()) {
            ammo = this.getCreativeProjectileStack();
        }
        this.shootProjectile(ammo, stack, worldIn, player, useTime);
        StatBase statBase = StatList.func_188057_b((Item)this);
        assert (statBase != null);
        player.func_71029_a(statBase);
        TinkerRangedWeapons.proxy.updateEquippedItemForRendering(entityLiving.func_184600_cs());
        TagUtil.setResetFlag(stack, true);
    }

    public void shootProjectile(@Nonnull ItemStack ammo, @Nonnull ItemStack bow, World worldIn, EntityPlayer player, int useTime) {
        float progress = this.getDrawbackProgress(bow, useTime);
        float power = ItemBow.func_185059_b((int)((int)(progress * 20.0f))) * progress * this.baseProjectileSpeed();
        power *= ProjectileLauncherNBT.from((ItemStack)bow).range;
        if (!worldIn.field_72995_K) {
            TinkerToolEvent.OnBowShoot event = TinkerToolEvent.OnBowShoot.fireEvent(bow, ammo, player, useTime, this.baseInaccuracy());
            for (int i = 0; i < event.projectileCount; ++i) {
                EntityArrow projectile;
                boolean usedAmmo = false;
                if (i == 0 || event.consumeAmmoPerProjectile) {
                    usedAmmo = this.consumeAmmo(ammo, player);
                }
                float inaccuracy = event.getBaseInaccuracy();
                if (i > 0) {
                    inaccuracy += event.bonusInaccuracy;
                }
                if ((projectile = this.getProjectileEntity(ammo, bow, worldIn, player, power, inaccuracy, progress * progress, usedAmmo)) == null || !ProjectileEvent.OnLaunch.fireEvent((Entity)projectile, bow, (EntityLivingBase)player)) continue;
                if (progress >= 1.0f) {
                    projectile.func_70243_d(true);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    ToolHelper.damageTool(bow, 1, (EntityLivingBase)player);
                }
                worldIn.func_72838_d((Entity)projectile);
            }
        }
        this.playShootSound(power, worldIn, player);
    }

    public EntityArrow getProjectileEntity(ItemStack ammo, ItemStack bow, World world, EntityPlayer player, float power, float inaccuracy, float progress, boolean usedAmmo) {
        if (ammo.func_77973_b() instanceof IAmmo) {
            return ((IAmmo)ammo.func_77973_b()).getProjectile(ammo, bow, world, player, power, inaccuracy, progress, usedAmmo);
        }
        if (ammo.func_77973_b() instanceof ItemArrow) {
            EntityArrow projectile = ((ItemArrow)ammo.func_77973_b()).func_185052_a(world, ammo, (EntityLivingBase)player);
            projectile.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, power, inaccuracy);
            if (player.field_71075_bZ.field_75098_d) {
                projectile.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
            } else if (!usedAmmo) {
                projectile.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
            }
            return projectile;
        }
        return null;
    }

    public boolean consumeAmmo(ItemStack ammo, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (ammo.func_77973_b() instanceof IAmmo) {
            return ((IAmmo)ammo.func_77973_b()).useAmmo(ammo, (EntityLivingBase)player);
        }
        ammo.func_190918_g(1);
        if (ammo.func_190926_b()) {
            player.field_71071_by.func_184437_d(ammo);
        }
        return true;
    }

    @Nonnull
    protected ItemStack getCreativeProjectileStack() {
        return new ItemStack(Items.field_151032_g);
    }

    public void playShootSound(float power, World world, EntityPlayer entityPlayer) {
        world.func_184148_a(null, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + power * 0.5f);
    }

    @Override
    public ItemStack findAmmo(ItemStack weapon, EntityLivingBase player) {
        return AmmoHelper.findAmmoFromInventory(this.getAmmoItems(), (Entity)player);
    }

    @Override
    public ItemStack getAmmoToRender(ItemStack weapon, EntityLivingBase player) {
        if (ToolHelper.isBroken(weapon)) {
            return ItemStack.field_190927_a;
        }
        return this.findAmmo(weapon, player);
    }

    public abstract float baseProjectileDamage();

    public abstract float projectileDamageModifier();

    @Override
    public void modifyProjectileAttributes(Multimap<String, AttributeModifier> projectileAttributes, @Nullable ItemStack launcher, ItemStack projectile, float power) {
        double dmg = this.baseProjectileDamage() * power;
        if ((dmg += (double)ProjectileLauncherNBT.from((ItemStack)launcher).bonusDamage) != 0.0) {
            projectileAttributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(LAUNCHER_BONUS_DAMAGE, "Launcher bonus damage", dmg, 0));
        }
        if (this.projectileDamageModifier() != 0.0f) {
            projectileAttributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(LAUNCHER_DAMAGE_MODIFIER, "Launcher damage modifier", (double)(this.projectileDamageModifier() - 1.0f), 1));
        }
    }

    protected abstract List<Item> getAmmoItems();

    @Override
    @SideOnly(value=Side.CLIENT)
    public Material getMaterialForPartForGuiRendering(int index) {
        if (index == this.getRequiredComponents().size() - 1) {
            return ClientProxy.RenderMaterialString;
        }
        switch (index) {
            case 0: {
                return ClientProxy.RenderMaterials[0];
            }
            case 1: {
                return ClientProxy.RenderMaterials[2];
            }
            case 2: {
                return ClientProxy.RenderMaterials[1];
            }
        }
        return super.getMaterialForPartForGuiRendering(index);
    }
}

